import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import {Link} from '@components/Link';
import {TimeLeftTicker} from '@components/TimeLeftTicker';
import {getError} from '@blocks/utils';
import {VerificationModal} from '../../components/VerificationModal';
import {cn} from '@bem-react/classname';

import './VerificationPhoneModal.styl';

const b = cn('VerificationPhoneModal');

export class VerificationPhoneModal extends Component {
    state = {
        code: '',
        showTimer: true,
        isAccepted: false,
        error: null
    };
    componentDidUpdate(props) {
        const {visible, isConfirmInProgress, setPhoneConfirmInProgress} = this.props;

        if (!props.visible && visible) {
            if (!isConfirmInProgress) {
                setPhoneConfirmInProgress();
                this.showTimer();
            }
            this.setCode('');
        }
    }
    removeError = () => {
        const {error, setError} = this.props;

        if (error && error.source === 'phone_modal') {
            setError(null);
        }
    };
    onCodeChange = (e) => {
        if (e && e.target) {
            this.setCode(e.target.value);
        }
    };
    setCode = (code) => {
        this.removeError();
        this.setState({code});
    };
    onAccept = () => {
        const {postPhoneCommit} = this.props;
        const {code} = this.state;

        this.removeError();
        postPhoneCommit(code, this.setAccepted, this.onFailCommit);
    };
    setAccepted = () => this.setState({isAccepted: true});
    onFailCommit = ({errors}) => {
        const {setError} = this.props;
        const {text, code} = getError('phoneCode', errors[0]);

        setError({code, text, source: 'phone_modal'});
    };
    onFailResend = ({errors}) => {
        const {setError} = this.props;
        const {text, code} = getError('phone', errors[0]);

        setError({code, text, source: 'phone_modal'});
    };
    onResend = () => {
        const {postCreatePhone} = this.props;

        this.removeError();
        postCreatePhone(this.showTimer);
    };
    hideTimer = () => this.setState({showTimer: false});
    showTimer = () => this.setState({showTimer: true});
    maybeRenderContent = () => {
        const {isConfirmInProgress, error} = this.props;
        const {code, showTimer, isAccepted} = this.state;

        if (isAccepted) {
            return null;
        }

        return (
            <div className={b()} data-t='verification:modal:phone'>
                <div className={b('block')}>
                    <div className={b('code')}>
                        <Input
                            dataT='phone'
                            onChange={this.onCodeChange}
                            value={code}
                            autoComplete='off'
                            placeholder={i18n('Verification.phone-modal.code.placeholder')}
                            state={error && error.source === 'phone_modal' && 'error'}
                            hint={error && error.source === 'phone_modal' && error.text}
                            name='phoneCode'
                        />
                    </div>
                    <div className={b('resend', {showTimer})}>
                        {showTimer && isConfirmInProgress ? (
                            <>
                                {i18n('Verification.phone-modal.resend.timer')}{' '}
                                <TimeLeftTicker tickCount={30} onTickEnd={this.hideTimer} />
                            </>
                        ) : (
                            <Link size='m' width='max' onClick={this.onResend} data-t='verification:modal:phone:resend'>
                                {i18n('Verification.phone-modal.resend')}
                            </Link>
                        )}
                    </div>
                </div>
            </div>
        );
    };

    render() {
        const {visible, phone, closeModal} = this.props;
        const {code, isAccepted} = this.state;

        return (
            <VerificationModal
                visible={visible}
                title={
                    isAccepted
                        ? i18n('Verification.phone-modal.title.accepted')
                        : i18n('Verification.phone-modal.title')
                }
                text={
                    isAccepted
                        ? i18n('Verification.phone-modal.text.accepted')
                        : i18n('Verification.phone-modal.text').replace('%1', `<b>${phone}</b>`)
                }
                closeModal={closeModal}
                isAcceptDisabled={!(isAccepted || code)}
                onAccept={isAccepted ? closeModal : this.onAccept}
                showCancelButton={!isAccepted}
            >
                {this.maybeRenderContent()}
            </VerificationModal>
        );
    }
}

VerificationPhoneModal.propTypes = {
    visible: PropTypes.bool,
    isConfirmInProgress: PropTypes.bool,
    phone: PropTypes.string,
    closeModal: PropTypes.func,
    title: PropTypes.node,
    text: PropTypes.node,
    children: PropTypes.node,
    error: PropTypes.object,
    postCreatePhone: PropTypes.func,
    postPhoneCommit: PropTypes.func,
    setPhoneConfirmInProgress: PropTypes.func,
    setError: PropTypes.func
};
