import {connect} from 'react-redux';
import {VerificationPhoneModal as Modal} from './VerificationPhoneModal';
import {postPhoneCommit, postCreatePhone, setPhoneConfirmInProgress, setError} from '../../api';

const mapStateToProps = ({verification}) => {
    const {phone: {value = '', isConfirmInProgress} = {}, error} = verification || {};

    return {phone: value, isConfirmInProgress, error};
};

const mapDispatchToProps = {postPhoneCommit, postCreatePhone, setPhoneConfirmInProgress, setError};

export const VerificationPhoneModal = connect(mapStateToProps, mapDispatchToProps)(Modal);
