import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {VerificationModal} from '../../components/VerificationModal';

const errorsTexts = {
    'verification.write': i18n('Verification.errors.write'),
    'verification.social': i18n('Verification.errors.social'),
    'verification.reason': i18n('Verification.errors.reason'),
    'verification.default_email': i18n('Verification.errors.default_email'),
    'verification.photo': i18n('Verification.errors.photo'),
    default: i18n('Verification.errors.internal')
};

export class VerificationSendModal extends Component {
    onButtonClick = () => {
        window.location.reload();
    };

    render() {
        const {visible, closeModal, errors} = this.props;
        const error = errors.length && errors[0];

        return (
            <VerificationModal
                visible={visible}
                isTextCentered={true}
                isBigButtons={true}
                title={error ? i18n('Verification.send-modal.title.error') : i18n('Verification.send-modal.title')}
                text={error ? errorsTexts[error] || errorsTexts.default : i18n('Verification.send-modal.text')}
                buttonText={
                    error ? i18n('Verification.send-modal.button.error') : i18n('Verification.send-modal.button')
                }
                closeModal={error ? closeModal : this.onButtonClick}
                onAccept={error ? closeModal : this.onButtonClick}
            />
        );
    }
}

VerificationSendModal.propTypes = {
    visible: PropTypes.bool,
    closeModal: PropTypes.func,
    errors: PropTypes.arrayOf(PropTypes.string)
};
