import {
    ADD_SOCIAL,
    REMOVE_SOCIAL,
    SET_ERROR,
    SET_SOCIAL,
    SET_CHECKBOX_TERMS,
    SET_CHECKBOX_VERIFICATION,
    SET_CHECKBOX_DELETE,
    SET_PHOTO_SRC,
    SET_EMAIL,
    SET_EMAIL_CONFIRMED,
    SET_EMAIL_CONFIRM_IN_PROGRESS,
    SET_PHONE,
    SET_PHONE_CONFIRMED,
    SET_PHONE_CONFIRM_IN_PROGRESS,
    SET_REASON
} from '../actions';

const defaultState = {
    isPplMode: false,
    isLoggedIn: false,
    error: null,
    user: {
        name: '',
        publicName: '',
        publicId: '',
        login: ''
    },
    phone: {
        value: '',
        isConfirmed: false,
        isConfirmInProgress: false
    },
    email: {
        value: '',
        isConfirmed: false,
        isConfirmInProgress: false
    },
    photoSrc: '',
    socials: [''],
    reason: '',
    checkboxes: {
        isAcceptTerms: false,
        isAcceptVerification: false,
        isAcceptDelete: false
    },
    isLoading: false,
    links: {
        confidential: '',
        rules: '',
        landingPpl: ''
    },
    serpUri: ''
};

export const verification = (state = defaultState, action = {}) => {
    const {type, payload} = action;

    switch (type) {
        case ADD_SOCIAL:
            return Object.assign({}, state, {socials: [...state.socials, '']});
        case REMOVE_SOCIAL:
            return Object.assign({}, state, {
                socials: state.socials.filter((_, index) => index !== payload.index)
            });
        case SET_SOCIAL:
            return Object.assign({}, state, {
                socials: state.socials.map((social, index) => (index === payload.index ? payload.social : social))
            });
        case SET_CHECKBOX_TERMS:
            return Object.assign({}, state, {
                checkboxes: {
                    isAcceptTerms: payload.value,
                    isAcceptVerification: state.checkboxes.isAcceptVerification,
                    isAcceptDelete: state.checkboxes.isAcceptDelete
                }
            });
        case SET_CHECKBOX_VERIFICATION:
            return Object.assign({}, state, {
                checkboxes: {
                    isAcceptTerms: state.checkboxes.isAcceptTerms,
                    isAcceptVerification: payload.value,
                    isAcceptDelete: state.checkboxes.isAcceptDelete
                }
            });
        case SET_CHECKBOX_DELETE:
            return Object.assign({}, state, {
                checkboxes: {
                    isAcceptTerms: state.checkboxes.isAcceptTerms,
                    isAcceptVerification: state.checkboxes.isAcceptVerification,
                    isAcceptDelete: payload.value
                }
            });
        case SET_PHOTO_SRC:
            return Object.assign({}, state, {photoSrc: payload.src});
        case SET_EMAIL:
            return Object.assign({}, state, {
                email: {
                    value: payload.value,
                    isConfirmed: state.email.isConfirmed,
                    isConfirmInProgress: false
                }
            });
        case SET_EMAIL_CONFIRMED:
            return Object.assign({}, state, {
                email: {
                    value: state.email.value,
                    isConfirmed: true,
                    isConfirmInProgress: false
                }
            });
        case SET_EMAIL_CONFIRM_IN_PROGRESS:
            return Object.assign({}, state, {
                email: {
                    value: state.email.value,
                    isConfirmed: state.email.isConfirmed,
                    isConfirmInProgress: true
                }
            });
        case SET_PHONE:
            return Object.assign({}, state, {
                phone: {
                    value: payload.value,
                    isConfirmed: false,
                    isConfirmInProgress: false
                }
            });
        case SET_PHONE_CONFIRMED:
            return Object.assign({}, state, {
                phone: {
                    value: state.phone.value,
                    isConfirmed: true,
                    isConfirmInProgress: false
                }
            });
        case SET_PHONE_CONFIRM_IN_PROGRESS:
            return Object.assign({}, state, {
                phone: {
                    value: state.phone.value,
                    isConfirmed: state.phone.isConfirmed,
                    isConfirmInProgress: true
                }
            });
        case SET_REASON:
            return Object.assign({}, state, {reason: payload});
        case SET_ERROR:
            return Object.assign({}, state, {error: payload});
        default:
            return state;
    }
};
