const api = jest.genMockFromModule('../api');

api.request = jest.fn();

api.request.mockImplementation(() => {
    function FakeApi() {
        this.done = function(fn) {
            fn({status: 'ok'});
            return this;
        };

        this.fail = function() {
            return this;
        };

        this.always = function() {
            return this;
        };
    }
    return new FakeApi();
});

api.__mockSuccess = (data) =>
    api.request.mockImplementation(() => {
        function FakeApi() {
            this.done = function(fn) {
                fn(data);
                return this;
            };
            this.fail = function() {
                return this;
            };

            this.always = function() {
                return this;
            };
        }
        return new FakeApi();
    });

api.__mockFail = (data) =>
    api.request.mockImplementation(() => {
        function FakeApi() {
            this.done = function() {
                return this;
            };
            this.fail = function(fn) {
                fn(data);
                return this;
            };

            this.always = function() {
                return this;
            };
        }
        return new FakeApi();
    });

api.__mockAlways = () =>
    api.request.mockImplementation(() => {
        function FakeApi() {
            this.done = function() {
                return this;
            };
            this.fail = function() {
                return this;
            };

            this.always = function(fn) {
                fn();
                return this;
            };
        }
        return new FakeApi();
    });

export default api;
