import metrics from '@blocks/metrics';

export const UPDATE_EMPTY_ERRORS = 'UPDATE_EMPTY_ERRORS';
export const UPDATE_HINT_CUSTOM_QUESTION_STATE = 'UPDATE_HINT_CUSTOM_QUESTION_STATE';
export const UPDATE_HINT_QUESTION_STATES = 'UPDATE_HINT_QUESTION_STATES';
export const UPDATE_PHONE_CODE_STATE = 'UPDATE_PHONE_CODE_STATE';
export const UPDATE_PHONE_STATES_TO_DEFAULTS = 'UPDATE_PHONE_STATES_TO_DEFAULTS';
export const UPDATE_STATES = 'UPDATE_STATES';
export const UPDATE_PHONE_VALUES_TO_DEFAULTS = 'UPDATE_PHONE_VALUES_TO_DEFAULTS';
export const UPDATE_FORM_TYPE = 'UPDATE_TYPE';
export const UPDATE_QUESTION_VALUES = 'UPDATE_QUESTION_VALUES';
export const UPDATE_VALUES = 'UPDATE_VALUES';
export const UPDATE_ERRORS = 'UPDATE_ERRORS';
export const UPDATE_ERRORS_VALID = 'UPDATE_ERRORS_VALID';
export const SET_GROUP_ERRORS = 'SET_GROUP_ERRORS';
export const UPDATE_GLOBAL_HINT_STATUS = 'UPDATE_GLOBAL_HINT_STATUS';
export const SET_FIELD_ERROR_ACTIVE = 'SET_FIELD_ERROR_ACTIVE';
export const CHANGE_CALL_CONFIRMATION_PROCESS = 'CHANGE_CALL_CONFIRMATION_PROCESS';
export const CHANGE_PHONE_CONFIRMATION_TYPE = 'CHANGE_PHONE_CONFIRMATION_TYPE';
export const FORCE_CHECKED_CONFIRMATION_CODE = 'FORCE_CHECKED_CONFIRMATION_CODE';
export const HUMAN_CONFIRMATION_DONE = 'HUMAN_CONFIRMATION_DONE';
export const SET_CALL_CONFIRMATION_TIMER = 'SET_CALL_CONFIRMATION_TIMER';
export const SET_CONFIRMATION_CODE_LENGTH = 'SET_CONFIRMATION_CODE_LENGTH';
export const SET_MAGIC_CONFIRMATION_CODE = 'SET_MAGIC_CONFIRMATION_CODE';
export const UPDATE_VALIDATION_METHOD = 'UPDATE_VALIDATION_METHOD';
export const UPDATE_FORM_PREFIX = 'UPDATE_FORM_PREFIX';
export const VALIDATE_PHONE_FOR_CALL = 'VALIDATE_PHONE_FOR_CALL';
export const GET_QUESTIONS_LIST = 'GET_QUESTIONS_LIST';
export const UPDATE_CONFIRMATION_FETCHING_STATUS = 'UPDATE_CONFIRMATION_FETCHING_STATUS';
export const CHANGE_ACTIVE_FIELD = 'CHANGE_ACTIVE_FIELD';
export const SET_CAPTCHA_REQUIRED = 'SET_CAPTCHA_REQUIRED';
export const TOGGLE_PASSWORD_VISIBILITY_STATE = 'TOGGLE_PASSWORD_VISIBILITY_STATE';
export const SET_PASSWORD_WEIGHT = 'SET_PASSWORD_WEIGHT';
export const SUGGEST_PASSWORD = 'SUGGEST_PASSWORD';
export const CLEAR_FORM = 'CLEAR_FORM';
export const TOGGLE_SERVICE_SUBSCRIPTION_PERMISSION = 'TOGGLE_SERVICE_SUBSCRIPTION_PERMISSION';

export function setCaptchaRequired(isRequired) {
    return {
        type: SET_CAPTCHA_REQUIRED,
        isRequired
    };
}

export function changeActiveField(field) {
    return {
        type: CHANGE_ACTIVE_FIELD,
        field
    };
}

export function updateConfirmationFetchingStatus(data) {
    return {
        type: UPDATE_CONFIRMATION_FETCHING_STATUS,
        data
    };
}

export function updateFormType(formType) {
    return {
        type: UPDATE_FORM_TYPE,
        payload: formType
    };
}

export function updateFormPrefix(prefix) {
    return {
        type: UPDATE_FORM_PREFIX,
        payload: prefix
    };
}

export function getUserQuestionsList(questions) {
    return {
        type: GET_QUESTIONS_LIST,
        questions
    };
}

export function validatePhoneForCall(isValid) {
    return {
        type: VALIDATE_PHONE_FOR_CALL,
        isValid
    };
}

export function updateValidationMethod(method) {
    return {
        type: UPDATE_VALIDATION_METHOD,
        method
    };
}

export function setMagicConfirmationCode(code) {
    return {
        type: SET_MAGIC_CONFIRMATION_CODE,
        code
    };
}

export function setConfirmationCodeLength(codeLength) {
    return {
        type: SET_CONFIRMATION_CODE_LENGTH,
        codeLength
    };
}

export function setCallConfirmationTimer(timer) {
    return {
        type: SET_CALL_CONFIRMATION_TIMER,
        timer
    };
}

export function updateHumanConfirmationStatus(state) {
    return {
        type: HUMAN_CONFIRMATION_DONE,
        state
    };
}

export function forceCheckedConfirmationCode() {
    return {
        type: FORCE_CHECKED_CONFIRMATION_CODE
    };
}

export function changePhoneConfirmationType(phoneConfirmationType) {
    return {
        type: CHANGE_PHONE_CONFIRMATION_TYPE,
        phoneConfirmationType
    };
}

export function changeCallConfirmationProcess(process) {
    return {
        type: CHANGE_CALL_CONFIRMATION_PROCESS,
        process
    };
}

export function updateErrorStates(fields) {
    return {
        type: UPDATE_EMPTY_ERRORS,
        fields
    };
}

export function updateQuestionCustomState(data) {
    return {
        type: UPDATE_HINT_CUSTOM_QUESTION_STATE,
        data
    };
}

export function updateQuestionStates(data) {
    return {
        type: UPDATE_HINT_QUESTION_STATES,
        data
    };
}

export function updatePhoneStatesToDefaults() {
    return {
        type: UPDATE_PHONE_STATES_TO_DEFAULTS
    };
}

export function updateStates(data) {
    return (dispatch, getState) => {
        const {
            form: {prefix}
        } = getState();

        dispatch({
            type: UPDATE_STATES,
            data
        });

        if (data.status === 'valid' && data.field !== 'phone') {
            metrics.send(['Успешное заполнение', data.field]);
            metrics.goal(`${prefix}_field_valid_${data.field}`);
        }
    };
}

export function updatePhoneValuesToDefaults() {
    return {
        type: UPDATE_PHONE_VALUES_TO_DEFAULTS
    };
}

export function setPhoneCodeSent() {
    return {
        type: UPDATE_PHONE_CODE_STATE,
        status: 'codeSent'
    };
}

export function updateQuestionValues(data) {
    return {
        type: UPDATE_QUESTION_VALUES,
        data
    };
}

export function updateValues(data) {
    return {
        type: UPDATE_VALUES,
        data
    };
}

export function updateErrors(data) {
    return {
        type: UPDATE_ERRORS,
        data
    };
}

export function updateErrorsValid(field) {
    return {
        type: UPDATE_ERRORS_VALID,
        field
    };
}

export function updateGroupErrors(data) {
    return {
        type: SET_GROUP_ERRORS,
        data
    };
}

export function updateHintStatus(status) {
    return {
        type: UPDATE_GLOBAL_HINT_STATUS,
        status
    };
}

export function setFieldErrorActive(field) {
    return {
        type: SET_FIELD_ERROR_ACTIVE,
        field
    };
}

export function toggleServiceSubscriptionPermission(isChecked = false) {
    return {
        type: TOGGLE_SERVICE_SUBSCRIPTION_PERMISSION,
        isChecked
    };
}

export const togglePasswordVisibilityState = () => (dispatch) => dispatch({type: TOGGLE_PASSWORD_VISIBILITY_STATE});

export const setPasswordWeight = (passwordWeight = '') => (dispatch) =>
    dispatch({type: SET_PASSWORD_WEIGHT, payload: {passwordWeight}});

export const suggestPassword = (suggestedPassword) => (dispatch) =>
    dispatch({type: SUGGEST_PASSWORD, payload: {suggestedPassword}});

export const clearForm = () => (dispatch) => dispatch({type: CLEAR_FORM});
