import api from '@blocks/api';
import {getLanguage, getTrackId} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {updateErrors} from '@blocks/actions/form';
import {FIELDS_NAMES} from '@components/Field/names';
import {getError} from '@blocks/utils';
import {changeLoadingStatus} from '@blocks/actions/spin';
import {setPhoneCodeChecked, setPhoneCodeSent, updatePhoneInfo} from './';

export function sendCode(number) {
    return function(dispatch, getState) {
        const state = getState();
        const {settings = {}} = state;
        const params = {
            track_id: getTrackId(state, TRACK_TYPES.COMMON),
            number,
            country: settings.country,
            display_language: getLanguage(state)
        };

        dispatch(changeLoadingStatus(true));
        api.request('yasms.secure.bind.submit', params)
            .done((response = {}) => {
                if (response.status === 'ok') {
                    const {operation} = response;

                    dispatch(
                        updatePhoneInfo({
                            operationId: operation.id,
                            phoneId: operation.phoneId
                        })
                    );
                    return dispatch(setPhoneCodeSent());
                }

                dispatch(updateErrors({field: FIELDS_NAMES.PHONE, error: getError(FIELDS_NAMES.PHONE, 'global')}));
            })
            .fail((error) => {
                const errorCode = (error.error && error.error[0]) || (error.errors && error.errors[0]);

                dispatch(updateErrors({field: FIELDS_NAMES.PHONE, error: getError(FIELDS_NAMES.PHONE, errorCode)}));
            })
            .always(() => dispatch(changeLoadingStatus(false)));
    };
}

export function finishPhoneBind() {
    return (dispatch, getState) => {
        const state = getState();
        const {phoneProcess} = state;

        api.request('yasms.secure.bind.commit', {
            track_id: getTrackId(state, TRACK_TYPES.COMMON),
            id: phoneProcess.operationId
        })
            .done((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(setPhoneCodeChecked());
                    return;
                }

                dispatch(updateErrors({field: FIELDS_NAMES.PHONE, error: getError(FIELDS_NAMES.PHONE, 'global')}));
            })
            .fail((error = {}) => {
                const errorCode = Array.isArray(error.errors) ? error.errors[0] : 'global';
                const fieldFromError = errorCode.split('.')[0];
                const field = fieldFromError === 'code' ? FIELDS_NAMES.PHONE_CODE : fieldFromError;

                dispatch(updateErrors({field: field, error: getError(field, errorCode)}));
            })
            .always(() => dispatch(changeLoadingStatus(false)));
    };
}
