import api from '@blocks/api';
import {Greed} from '@plibs/greed';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {getTrackId} from '@blocks/selectors';

export function sendFingerprint() {
    return async (_dispatch, getState) => {
        try {
            const state = getState();
            const {common} = state;
            const {yandexuid, uid} = common;

            if (Greed && Greed.safeGet) {
                const greedResult = await Greed.safeGet();
                const trackId = getTrackId(state, TRACK_TYPES.REGISTER) || null;

                const data = {
                    action: 'fingerprint',
                    greedResult: JSON.stringify(greedResult),
                    yandexuid,
                    uid
                };

                if (trackId) {
                    data.track_id = trackId;
                }

                api.log(data, {
                    encrypt: true
                });
            }
        } catch (error) {
            // DO NOTHING
        }
    };
}
