import api from '@blocks/api';
import {setEditMode} from '@blocks/common/actions';
import {hasExp} from '@blocks/selectors';
import {getCookie} from '@blocks/utils';

export function setSurveyPopupVisible() {
    return (dispatch) => {
        setTimeout(() => {
            dispatch(setEditMode('SHOW_SURVEY'));
        }, 3000);
    };
}

export function handleSurveyPopup() {
    return (dispatch, getState) => {
        const {common} = getState();
        const isSurveyExperiment = hasExp({common}, 'profile-opros-exp');
        const isCookieSet = Boolean(getCookie('user_feedback'));

        if (isSurveyExperiment && !isCookieSet) {
            dispatch(setSurveyPopupVisible());
        }
    };
}

export function writeUserDataToStatbox(data) {
    return (dispatch, getState) => {
        const {common, person} = getState();
        const {process_uuid, uid, track_id} = common;
        const statboxData = Object.assign(data, {
            uid,
            track_id,
            process_uuid,
            login: person.login,
            mode: 'profile_feedback'
        });

        return api.request('statbox', statboxData);
    };
}
