import api from '@blocks/api';
import processErrors from '@blocks/avatar-displayname/utils/processErrors';
import {setPublicAccessError} from '@blocks/actions/publicAccess';
import handleUpdates from '@blocks/avatar-displayname/actions/handleUpdates';

export function togglePersonalDataPermission() {
    return (dispatch, getState) => {
        const state = getState();
        const {publicAccess = {}, common = {}} = state;
        const {hasPublicProfile, hasThirdPartyAccess} = publicAccess;
        const params = {
            track_id: common.track_id,
            personal_data_public_access_allowed: hasPublicProfile,
            personal_data_third_party_processing_allowed: hasThirdPartyAccess
        };

        api.request('toggle-personal-data-access', params)
            .done((response = {}) => {
                if (response.status !== 'ok') {
                    dispatch(setPublicAccessError(processErrors()));
                }
                dispatch(handleUpdates());
            })
            .fail(() => {
                dispatch(setPublicAccessError(processErrors()));
            });
    };
}
