import PropTypes from 'prop-types';
import React, {Component} from 'react';

export class Account extends Component {
    render() {
        const {
            avatar,
            avatarId,
            displayName,
            isAccountListEditing,
            isAuthorized,
            isDefault,
            isTouch,
            login,
            logoutUrl,
            fallbackUrl,
            onClick,
            onCrossClick
        } = this.props;

        const isDeleted = !login;

        const spanStyle = {
            backgroundImage: `url(https://${avatar.host}${avatar.pathname
                .replace('%uid%', avatarId)
                .replace('%size%', '200')
                .replace('%login%', login)})`
        };

        function crossClick(e) {
            e.stopPropagation();
            e.preventDefault();
            onCrossClick();
        }

        const showCross = !isTouch || (isTouch && isAccountListEditing);

        if (isDefault) {
            return (
                <li className='passport-AccountList-Item'>
                    <a href={fallbackUrl} onClick={onClick} className='passport-AccountList-Link'>
                        {showCross && (
                            <span href={logoutUrl} onClick={crossClick} className='passport-AccountList-Remove'>
                                <span className='passport-Icon passport-Icon_remove' />
                            </span>
                        )}
                        <div style={spanStyle} className='passport-AccountList-Userpic passport-Userpic'>
                            <span className='passport-Icon passport-Icon_ok' />
                        </div>
                        <span className='passport-AccountList-Text'>
                            <strong>{displayName}</strong>
                        </span>
                    </a>
                </li>
            );
        }

        if (isAuthorized) {
            return (
                <li className='passport-AccountList-Item passport-false'>
                    <a href={fallbackUrl} onClick={onClick} className='passport-AccountList-Link'>
                        <span style={spanStyle} className='passport-AccountList-Userpic passport-Userpic'>
                            <span className='passport-Icon passport-Icon_ok' />
                        </span>
                        {showCross && (
                            <span onClick={crossClick} className='passport-AccountList-Remove'>
                                <span className='passport-Icon passport-Icon_remove' />
                            </span>
                        )}
                        <span className='passport-AccountList-Text'>{displayName}</span>
                    </a>
                </li>
            );
        }

        if (isDeleted) {
            return (
                <li className='passport-AccountList-Item passport-AccountList-Item_needsPassword'>
                    <a href={fallbackUrl} className='passport-AccountList-Link'>
                        <span style={spanStyle} className='passport-AccountList-Userpic passport-Userpic' />
                        {showCross && (
                            <span onClick={crossClick} className='passport-AccountList-Remove'>
                                <span className='passport-Icon passport-Icon_remove' />
                            </span>
                        )}
                        <span className='passport-AccountList-Text'>Аккаунт удалён</span>
                    </a>
                </li>
            );
        }

        return (
            <li className='passport-AccountList-Item passport-AccountList-Item_needsPassword'>
                <a href={fallbackUrl} onClick={onClick} className='passport-AccountList-Link'>
                    <span style={spanStyle} className='passport-AccountList-Userpic passport-Userpic' />
                    {showCross && (
                        <span onClick={crossClick} className='passport-AccountList-Remove'>
                            <span className='passport-Icon passport-Icon_remove' />
                        </span>
                    )}
                    <span className='passport-AccountList-Text'>{displayName}</span>
                    <span className='passport-AccountList-Note'>{i18n('OneDomik.AccountList.note')}</span>
                </a>
            </li>
        );
    }
}

Account.propTypes = {
    avatarId: PropTypes.string,
    avatar: PropTypes.object,
    displayName: PropTypes.string,
    isAccountListEditing: PropTypes.bool,
    isAuthorized: PropTypes.bool,
    isDefault: PropTypes.bool,
    isTouch: PropTypes.bool,
    login: PropTypes.string,
    onClick: PropTypes.func,
    onCrossClick: PropTypes.func,
    logoutUrl: PropTypes.string,
    fallbackUrl: PropTypes.string
};
