import api from '@blocks/api';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import {updateCSRF, setupBackPane} from '@blocks/common/actions';
import {push, replace} from 'react-router-redux';

export const ONE_DOMIK_GOAL_PREFIX = 'one_domik_v2';

export const SHOW_ACCOUNTS = 'SHOW_ACCOUNTS';
export const SHOW_ACCOUNTS_SUCCESS = 'SHOW_ACCOUNTS_SUCCESS';
export const SHOW_ACCOUNTS_FAIL = 'SHOW_ACCOUNTS_FAIL';
export const SHOW_FORM = 'SHOW_FORM';
export const SHOW_MAGIC = 'SHOW_MAGIC';
export const SHOW_SOCIAL = 'SHOW_SOCIAL';
export const SHOW_SUGGEST = 'SHOW_SUGGEST';

export const GET_TRACK_AND_CSRF = 'GET_TRACK_AND_CSRF';

export const SWITCH_TO_RFC_TOTP = 'SWITCH_TO_RFC_TOTP';
export const SWITCH_TO_MAGIC = 'SWITCH_TO_MAGIC';
export const SWITCH_MODE_TO_ADDING_ACCOUNT = 'SWITCH_MODE_TO_ADDING_ACCOUNT';
export const SWITCH_MODE_TO_EDIT = 'SWITCH_MODE_TO_EDIT';

export const LOGOUT_ACCOUNT = 'LOGOUT_ACCOUNT';

export const FORGET_ACCOUNT = 'FORGET_ACCOUNT';
export const FORGET_ACCOUNT_SUCCESS = 'FORGET_ACCOUNT_SUCCESS';
export const FORGET_ACCOUNT_FAIL = 'FORGET_ACCOUNT_FAIL';

export const INPUT_LOGIN = 'INPUT_LOGIN';
export const INPUT_LOGIN_SUCCESS = 'INPUT_LOGIN_SUCCESS';
export const INPUT_LOGIN_FAIL = 'INPUT_LOGIN_FAIL';

export const CHANGE_ACTIVE_ACCOUNT = 'CHANGE_ACTIVE_ACCOUNT';
export const LOGIN_SUGGESTED_ACCOUNT = 'LOGIN_SUGGESTED_ACCOUNT';
export const REDIRECT_TO_RETPATH = 'REDIRECT_TO_RETPATH';
export const REDIRECT_TO_BACKPATH = 'REDIRECT_TO_BACKPATH';

export const CHANGE_DEFAULT_ACCOUNT = 'CHANGE_DEFAULT_ACCOUNT';
export const REMOVE_ACCOUNT = 'REMOVE_ACCOUNT';
export const ADD_ACCOUNT = 'ADD_ACCOUNT';
export const PROCESS_EMB_ANSWER = 'PROCESS_EMB_ANSWER';
export const SHOW_MAGIC_ERROR = 'SHOW_MAGIC_ERROR';

export const UPDATE_LOGIN_VALUE = 'UPDATE_LOGIN_VALUE';
export const UPDATE_PASSWORD_VALUE = 'UPDATE_PASSWORD_VALUE';
export const UPDATE_CAPTCHA_VALUE = 'UPDATE_CAPTCHA_VALUE';

export const UPDATE_TOKENS = 'UPDATE_TOKENS';
export const UPDATE_TOKENS_SUCCESS = 'UPDATE_TOKENS_SUCCESS';
export const UPDATE_TOKENS_FAIL = 'UPDATE_TOKENS_FAIL';

export const INIT_ADDITIONAL_DATA_REQUEST = 'INIT_ADDITIONAL_DATA_REQUEST';

export const TOGGLE_ACCOUNT_LIST_EDITING = 'TOGGLE_ACCOUNT_LIST_EDITING';

export const DO_MODE_ANIMATION = 'DO_MODE_ANIMATION';
export const PROCESS_ANIMATION_END = 'PROCESS_ANIMATION_END';

export const SWITCH_PASSWORD_TYPE = 'SWITCH_PASSWORD_TYPE';
export const SWITCH_LOGIN_EMPTY_STATE = 'SWITCH_LOGIN_EMPTY_STATE';
export const SWITCH_PASSWORD_EMPTY_STATE = 'SWITCH_PASSWORD_EMPTY_STATE';
export const SWITCH_CAPTCHA_EMPTY_STATE = 'SWITCH_CAPTCHA_EMPTY_STATE';

export const SWITCH_FORM_SUBMITTED_STATE = 'SWITCH_FORM_SUBMITTED_STATE';
export const CHECK_IFRAME = 'CHECK_IFRAME';

export const DOMIK_IS_LOADING = 'DOMIK_IS_LOADING';

export function checkIframe(isPassed) {
    return {
        type: CHECK_IFRAME,
        isPassed
    };
}

export function showForm(show) {
    return {
        type: SHOW_FORM,
        show
    };
}

export function switchPasswordType(passwordType) {
    return {
        type: SWITCH_PASSWORD_TYPE,
        passwordType
    };
}

export function switchLoginEmptyState(isEmpty) {
    return {
        type: SWITCH_LOGIN_EMPTY_STATE,
        isEmpty
    };
}

export function switchFormSubmittedState(isSubmitted) {
    return function(dispatch) {
        clearTimeout(window.submittedTimeout);

        window.submittedTimeout = window.setTimeout(function() {
            dispatch({
                type: SWITCH_FORM_SUBMITTED_STATE,
                isSubmitted: false
            });
        }, 5000);

        dispatch({
            type: SWITCH_FORM_SUBMITTED_STATE,
            isSubmitted
        });
    };
}

export function switchPasswordEmptyState(isEmpty) {
    return {
        type: SWITCH_PASSWORD_EMPTY_STATE,
        isEmpty
    };
}

export function switchCaptchaEmptyState(isEmpty) {
    return {
        type: SWITCH_CAPTCHA_EMPTY_STATE,
        isEmpty
    };
}

export function toggleAccountListEditing(enable) {
    return {
        type: TOGGLE_ACCOUNT_LIST_EDITING,
        enable
    };
}

export function updateLoginValue(value) {
    return {
        type: UPDATE_LOGIN_VALUE,
        value
    };
}

export function updatePasswordValue(value) {
    return {
        type: UPDATE_PASSWORD_VALUE,
        value
    };
}

export function updateCaptchaValue(value) {
    return {
        type: UPDATE_CAPTCHA_VALUE,
        value
    };
}

export function addAccount(data) {
    return {
        type: ADD_ACCOUNT,
        data
    };
}

export function processEmbAnswer(data) {
    return function(dispatch, getState) {
        const state = getState();
        const oneDomik = state.one_domik;

        if (data.errors && ['password.not_matched', 'password.empty', 'rfc_otp.invalid'].indexOf(data.errors) > -1) {
            dispatch(updatePasswordValue(''));
        }

        if (
            oneDomik.captchaRequired &&
            data.errors &&
            ['captcha.invalid', 'captcha.required'].indexOf(data.errors) > -1
        ) {
            dispatch(reloadCaptcha());
        }

        dispatch({
            type: PROCESS_EMB_ANSWER,
            data
        });
    };
}

export function switchModeToEdit() {
    return function(dispatch, getState) {
        const state = getState();

        dispatch(push(state.common.editUrl));
        dispatch(setupBackPane(null));

        dispatch({
            type: SWITCH_MODE_TO_EDIT
        });
    };
}

export function doModeAnimation(mode) {
    return function(dispatch) {
        dispatch({
            type: DO_MODE_ANIMATION,
            mode
        });
    };
}

export function processAnimationEnd(event) {
    return function(dispatch) {
        if (event.propertyName !== 'transform') {
            return;
        }

        dispatch({
            type: PROCESS_ANIMATION_END,
            event
        });
    };
}

export function switchToMagic() {
    return function(dispatch, getState) {
        const state = getState();

        dispatch(setupBackPane(true));

        dispatch(push(state.common.magicUrl));

        dispatch({
            type: SWITCH_TO_MAGIC
        });
    };
}

export function switchToRfcTotp() {
    return function(dispatch) {
        dispatch({
            type: SWITCH_TO_RFC_TOTP
        });
    };
}

export function clearFormState() {
    return function(dispatch) {
        dispatch({
            type: SWITCH_MODE_TO_ADDING_ACCOUNT,
            needEmpty: true
        });
    };
}

export function switchModeToAddingAccount(needEmpty) {
    return function(dispatch, getState) {
        const state = getState();

        dispatch(push(state.common.addUserUrl));

        if (Object.keys(state.one_domik.unitedAccounts).length > 0) {
            dispatch(setupBackPane(state.common.editUrl));
        } else {
            dispatch(setupBackPane(null));
        }

        dispatch({
            type: SWITCH_MODE_TO_ADDING_ACCOUNT,
            needEmpty
        });
    };
}

export function redirect(url) {
    const form = document.createElement('form');
    const element1 = document.createElement('input');

    form.method = 'GET';
    form.action = '/redirect';

    element1.value = url;
    element1.name = 'url';
    form.appendChild(element1);

    document.body.appendChild(form);

    form.submit();
    form.parentNode.removeChild(form);
}

export function submitIframeCheck() {
    return function(dispatch, getState) {
        const state = getState();

        const form = document.createElement('form');
        const handle = `${state.common.loginStatusRetpath}?status=ok&action=check`;

        form.method = 'POST';
        form.action = handle;
        form.target = 'iframe';

        document.body.appendChild(form);

        form.submit();
        form.parentNode.removeChild(form);
    };
}

function autoLogIn(uid, action, state) {
    const form = document.createElement('form');
    const element1 = document.createElement('input');
    const element2 = document.createElement('input');
    const element3 = document.createElement('input');
    const element4 = document.createElement('input');
    const handle = state.common.embeddedauth_url;

    form.method = 'POST';
    form.action = handle;
    form.target = 'iframe';

    element1.value = uid;
    element1.name = 'uid';
    form.appendChild(element1);

    element2.value = action;
    element2.name = 'action';
    form.appendChild(element2);

    element3.value = `${state.common.loginStatusRetpath}?action=${action}`;
    element3.name = 'retpath';
    form.appendChild(element3);

    element4.value = state.common.yu;
    element4.name = 'yu';
    form.appendChild(element4);

    document.body.appendChild(form);

    form.submit();
    form.parentNode.removeChild(form);
}

export function redirectToRetpath() {
    return function(dispatch, getState) {
        const state = getState();
        const url = state.common.retpath || state.common.profile_url;

        dispatch({
            type: REDIRECT_TO_RETPATH
        });

        dispatch(restoreStateAndRedirect(url));
    };
}

export function redirectToBackpath() {
    return function(dispatch, getState) {
        const state = getState();
        const url = state.common.backpath || state.common.profile_url;

        dispatch({
            type: REDIRECT_TO_BACKPATH
        });

        dispatch(restoreStateAndRedirect(url));
    };
}

export function restoreStateAndRedirect(url) {
    return function(dispatch, getState) {
        const {editUrl} = getState().common;

        dispatch({
            type: DOMIK_IS_LOADING,
            loading: true
        });

        dispatch(replace(editUrl));

        redirect(url);
    };
}

export function changeActiveAccount(uid) {
    return function(dispatch, getState) {
        const state = getState();

        dispatch({
            type: CHANGE_ACTIVE_ACCOUNT,
            uid
        });

        autoLogIn(uid, 'change_default', state);
    };
}

export function logoutAccount(uid) {
    return function(dispatch, getState) {
        const state = getState();

        autoLogIn(uid, 'logout', state);

        dispatch({
            type: LOGOUT_ACCOUNT,
            uid
        });
    };
}

export function additionalDataAsk() {
    return function(dispatch, getState) {
        const {
            common: {askEmailUrl, askPhoneUrl, askSocialUrl},
            settings: {ua},
            am = {}
        } = getState();

        if (am.isAm) {
            return dispatch(redirectToRetpath());
        }

        api.request('accounts')
            .done((res) => {
                const data = {};

                data.csrf_token = res.csrf; // eslint-disable-line
                data.uid = res.defaultAccount && res.defaultAccount.uid;

                dispatch(updateCSRF(res.csrf));

                api.request('auth/additional_data/ask', data)
                    .done((payload) => {
                        const state = payload.state;
                        const action = payload.action;

                        dispatch(initAdditionalDataRequest(payload));
                        dispatch(setupBackPane());

                        if (state === 'phone') {
                            dispatch(showAccounts());
                            dispatch(replace(askPhoneUrl));
                            return;
                        }

                        if (state === 'email') {
                            dispatch(showAccounts());
                            dispatch(replace(askEmailUrl));
                            return;
                        }

                        const availableSocialProviders = ['vk', 'ok', 'tw', 'mr', 'gg', 'fb'];
                        const isMobile = (ua.isMobile || ua.isTouch) && !ua.isTablet;

                        if (state === 'social') {
                            if (
                                (action === 'add' && !isMobile) ||
                                (action !== 'add' &&
                                    availableSocialProviders.indexOf(payload.social.provider_code) > -1)
                            ) {
                                dispatch(showAccounts());
                                dispatch(replace(askSocialUrl));

                                return;
                            }
                        }

                        dispatch(redirectToRetpath());
                    })
                    .fail(() => {
                        dispatch(redirectToRetpath());
                    });
            })
            .fail(() => {
                dispatch(redirectToRetpath());
            });
    };
}

export function forgetAccount(uid) {
    return function(dispatch, getState) {
        const state = getState();
        const common = state.common;
        const data = {
            _uid: uid
        };

        data.csrf_token = common.csrf; // eslint-disable-line

        dispatch({
            type: FORGET_ACCOUNT,
            data
        });

        api.request('accounts/forget', data)
            .done(() => {
                dispatch(showAccounts());

                dispatch({
                    type: FORGET_ACCOUNT_SUCCESS
                });
            })
            .fail((res) => {
                dispatch(showAccounts());

                dispatch({
                    type: FORGET_ACCOUNT_FAIL,
                    res
                });
            });
    };
}

export function loginSuggestedAccount(account) {
    return function(dispatch, getState) {
        const state = getState();
        const common = state.common;
        const welcomeUrl = common.welcomeUrl;
        const uid = account && account.uid;

        if (account.status === 'INVALID') {
            dispatch({
                type: DOMIK_IS_LOADING,
                loading: false
            });

            dispatch({
                type: LOGIN_SUGGESTED_ACCOUNT,
                account
            });

            // dispatch(setupBackPane(state.common.editUrl));

            dispatch(push(welcomeUrl));

            return;
        }

        const data = {
            _uid: uid
        };

        data.csrf_token = common.csrf; // eslint-disable-line

        dispatch({
            type: INPUT_LOGIN,
            data
        });

        api.request('accounts/input-login', data)
            .done((res) => {
                const inputLogin = {};

                if (!res.input_login) {
                    return;
                }

                inputLogin[uid] = res.input_login;

                dispatch({
                    type: INPUT_LOGIN_SUCCESS,
                    inputLogin
                });
            })
            .fail((res) => {
                dispatch({
                    type: INPUT_LOGIN_FAIL,
                    res
                });
            })
            .always(() => {
                dispatch({
                    type: DOMIK_IS_LOADING,
                    loading: false
                });

                dispatch({
                    type: LOGIN_SUGGESTED_ACCOUNT,
                    account
                });

                // dispatch(setupBackPane(state.common.editUrl));

                dispatch(push(welcomeUrl));
            });
    };
}

export function showAccounts() {
    return function(dispatch, getState) {
        const state = getState();
        const common = state.common;

        dispatch({
            type: SHOW_ACCOUNTS
        });

        api.request('accounts')
            .done((res) => {
                dispatch(updateCSRF(res.csrf));

                dispatch({
                    type: SHOW_ACCOUNTS_SUCCESS,
                    accounts: res.accounts
                });

                if (Object.keys(res.accounts.unitedAccounts).length === 0) {
                    dispatch(push(common.addUserUrl));
                }
            })
            .fail((res) => {
                dispatch({
                    type: SHOW_ACCOUNTS_FAIL,
                    res
                });
            });
    };
}

export function reAuthPasswordSubmit() {
    return function(dispatch, getState) {
        const state = getState();
        const common = state.common;
        const data = {};

        data.csrf_token = common.csrf; // eslint-disable-line

        dispatch({
            type: UPDATE_TOKENS
        });

        api.request('reAuthPasswordSubmit', data)
            .done((res) => {
                dispatch({
                    type: UPDATE_TOKENS_SUCCESS,
                    track_id: res.track_id,
                    csrf_token: res.csrf_token
                });
            })
            .fail((res) => {
                dispatch({
                    type: UPDATE_TOKENS_FAIL,
                    res
                });
            });
    };
}

export function setupQRCode() {
    return function(dispatch) {
        dispatch({
            type: SWITCH_TO_MAGIC
        });
    };
}

export function showMagicError(errors) {
    return function(dispatch) {
        if (errors && ['password.not_matched_2fa', 'password.empty'].indexOf(errors) > -1) {
            dispatch(updatePasswordValue(''));
        }

        dispatch({
            type: SHOW_MAGIC_ERROR,
            errors
        });
    };
}

export function domikIsLoading(loading) {
    return {
        type: DOMIK_IS_LOADING,
        loading
    };
}

export function initAdditionalDataRequest(payload) {
    return {
        type: INIT_ADDITIONAL_DATA_REQUEST,
        payload
    };
}
