import assign from 'lodash/assign';
import React from 'react';
import PropTypes from 'prop-types';
import Errors from '../errors/errors.jsx';
import Form from '../form/form.jsx';
import {SocialBlock, ExtendedSocialBlock} from '../social/social.jsx';
import Pane from '../pane.jsx';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import {
    doModeAnimation,
    switchModeToAddingAccount,
    switchModeToEdit,
    switchToMagic,
    updateLoginValue,
    updatePasswordValue,
    updateCaptchaValue,
    submitIframeCheck
} from '../actions';
import {startSocialAuth} from '../broker';

import {setupBackPane} from '../../common/actions';

function mapDispatchToProps(dispatch) {
    const actionCreators = {
        doModeAnimation,
        switchModeToAddingAccount,
        switchModeToEdit,
        switchToMagic,
        startSocialAuth,
        updatePasswordValue,
        updateLoginValue,
        updateCaptchaValue,
        submitIframeCheck
    };

    return assign(bindActionCreators(actionCreators, dispatch), {dispatch});
}

function mapStateToProps(state) {
    const {
        authorizedAccounts,
        captchaRequired,
        csrf_token,
        embAnswer,
        focused,
        form,
        submitCounter,
        isExpanded,
        loading,
        loginIsEmpty,
        passwordIsEmpty,
        captchaIsEmpty,
        formIsSubmitted,
        formIsUpgraded,
        passwordType,
        suggestedAccounts,
        track_id,
        processedAccount,
        mode,
        defaultAccount,
        inputLogin,
        unitedAccounts
    } = state.one_domik;

    const {
        backpath,
        clean,
        csrf,
        experiments,
        fretpath,
        from,
        embeddedauth_url,
        editUrl,
        auth_url,
        loginStatusRetpath,
        registration_url,
        restoration_url,
        retpath,
        yandex_url
    } = state.common;

    const {socialExtended, socialScope, tagline, display, minimal} = state.customs;

    const providers = state.social.providers;
    const captcha = state.captcha;

    const {isTouch, isMobile} = state.settings.ua;

    const isIE = ['MSIE', 'Edge'].indexOf(state.settings.ua.BrowserName) > -1;

    const {avatar, tld, lang, intranet} = state.settings;

    const formSettings = {
        target: '_self',
        handle: state.common.auth_url,
        retpath
    };

    if (formIsUpgraded) {
        formSettings.target = 'iframe';
        formSettings.handle = state.common.embeddedauth_url;
        formSettings.retpath = `${loginStatusRetpath}`;
    }

    return {
        account: defaultAccount,
        authorizedAccounts,
        avatar,
        backpath,
        clean,
        captcha,
        captchaIsEmpty,
        captchaRequired,
        csrf,
        csrf_token,
        embAnswer,
        editUrl,
        auth_url,
        embeddedauth_url,
        flagsString: experiments.flagsString,
        flags: experiments.flags || [],
        focused,
        form,
        formSettings,
        formIsSubmitted,
        fretpath,
        from,
        inputLogin,
        isExpanded,
        isIE,
        isMobile,
        isTouch,
        intranet,
        lang,
        loading,
        loginIsEmpty,
        loginStatusRetpath,
        minimal,
        mode,
        passwordIsEmpty,
        passwordType,
        processedAccount,
        providers,
        registration_url,
        restoration_url,
        retpath,
        socialExtended,
        socialScope,
        submitCounter,
        suggestedAccounts,
        display,
        tagline,
        tld,
        track_id,
        unitedAccounts,
        yandex_url
    };
}

class AddUser extends React.Component {
    componentDidMount() {
        if (Object.keys(this.props.unitedAccounts).length) {
            this.props.dispatch(setupBackPane(this.props.editUrl));
        }
    }

    render() {
        const paneCnames = this.props.paneCnames;
        const props = this.props;
        const isPhoneNumberExperiment = props.flags.indexOf('phone_alias_as_login_exp') > -1;

        return (
            <Pane cnames={paneCnames}>
                <Errors />
                <Form method={'password'} showLoginField={true} isPhoneNumberExperiment={isPhoneNumberExperiment} />
                {Boolean(!props.minimal && !props.intranet) &&
                    (props.socialExtended ? (
                        <ExtendedSocialBlock
                            showInfo={true}
                            providers={props.providers}
                            socialScope={props.socialScope}
                            onMouseDown={this.sendMetrics}
                            startSocialAuth={props.startSocialAuth}
                        />
                    ) : (
                        <SocialBlock
                            showInfo={true}
                            providers={props.providers}
                            socialScope={props.socialScope}
                            onMouseDown={this.sendMetrics}
                            startSocialAuth={props.startSocialAuth}
                        />
                    ))}
            </Pane>
        );
    }
}

AddUser.propTypes = {
    unitedAccounts: PropTypes.object,
    dispatch: PropTypes.func.isRequired,
    editUrl: PropTypes.string,
    paneCnames: PropTypes.object,
    flags: PropTypes.array,
    minimal: PropTypes.bool,
    intranet: PropTypes.bool,
    socialExtended: PropTypes.bool,
    providers: PropTypes.array,
    socialScope: PropTypes.object,
    startSocialAuth: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(AddUser);
