import api from '../../../api';
import {clearErrors, setErrors} from './';
import skipAdditionalData from './skip_additional_data';
import redirectToPasswordRequest from './redirect_to_password_request';
import sendMetrics from './send_metrics';
import {domikIsLoading} from '../../actions';

export default function approveActualPhone(phoneId) {
    return (dispatch, getState) => {
        const {
            settings: {lang},
            common: {csrf: csrf_token}
        } = getState();
        const params = {
            csrf_token,
            phone_id: phoneId,
            display_language: lang
        };

        dispatch(clearErrors());

        api.request('phone/manage/prolong_valid', params)
            .then(() => {
                dispatch(sendMetrics('approve_actual_phone', 'Показ актуализации телефона', 'Актуализация номера'));
                dispatch(skipAdditionalData('no'));
            })
            .catch((error) => {
                if (error.errors.indexOf('password.required') !== -1) {
                    dispatch(redirectToPasswordRequest());
                    return;
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
