import api from '@blocks/api';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import {setErrors, changeCaptchaState} from './';
import {domikIsLoading} from '@blocks/auth/actions';

export default function checkCaptcha(action, actionArguments) {
    return function(dispatch, getState) {
        const {
            additionalDataRequest: {captchaAnswer: answer, track_id},
            common: {csrf: csrf_token}
        } = getState();
        const params = {
            track_id,
            answer,
            csrf_token
        };

        if (!answer || !answer.trim()) {
            dispatch(setErrors(['captcha.empty']));
            return;
        }

        api.request('checkHuman', params)
            .then((response) => {
                if (response.status === 'ok') {
                    dispatch(changeCaptchaState(false));
                    dispatch(action(...actionArguments));
                    return;
                }

                dispatch(reloadCaptcha());
                dispatch(setErrors(response.errors));
                dispatch(domikIsLoading(false));
            })
            .catch((error) => {
                dispatch(reloadCaptcha());
                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
