import {redirectToRetpath, restoreStateAndRedirect} from '../../actions';
import sendMetrics from './send_metrics';

export default function redirectToEmailsPage() {
    return (dispatch, getState) => {
        const {
            settings: {host},
            common: {retpath}
        } = getState();

        let url = `${host}/profile/emails`;

        dispatch(sendMetrics('redirect_to_emails_page', 'Показ превращения емейла в защищенный', 'Изменить'));

        if (retpath) {
            url += `?retpath=${encodeURIComponent(retpath)}`;
            window.open(url);
            dispatch(redirectToRetpath());
            return;
        }

        dispatch(restoreStateAndRedirect(url));
    };
}
