import {restoreStateAndRedirect} from '../../actions';

export default function redirectToPasswordRequest() {
    return (dispatch, getState) => {
        const {
            one_domik: {processedAccount, defaultAccount},
            common: {auth_url: authUrl, currentUrl}
        } = getState();
        const account = processedAccount ? processedAccount : defaultAccount;

        let url = authUrl.split('?')[0];
        const queryParams = [];

        if (account) {
            queryParams.push(`login=${encodeURIComponent(account.login)}`);
        }

        if (currentUrl) {
            queryParams.push(`retpath=${encodeURIComponent(currentUrl)}`);
        }

        if (queryParams.length !== 0) {
            url += `?${queryParams.join('&')}`;
        }

        dispatch(restoreStateAndRedirect(url));
    };
}
