import {redirectToRetpath, restoreStateAndRedirect} from '../../actions';
import sendMetrics from './send_metrics';

export default function redirectToPhonesPage() {
    return (dispatch, getState) => {
        const {
            settings: {host},
            common: {retpath}
        } = getState();

        let url = `${host}/profile/phones`;

        dispatch(sendMetrics('redirect_to_phones_page', 'Показ превращения телефона в защищенный', 'Изменить'));

        if (retpath) {
            url += `?retpath=${encodeURIComponent(retpath)}`;
            window.open(url);
            dispatch(redirectToRetpath());
            return;
        }

        dispatch(restoreStateAndRedirect(url));
    };
}
