import api from '../../../api';
import {domikIsLoading, redirectToRetpath} from '../../actions';
import {setErrors, clearErrors, sentEmailConfirmationCodeSuccess} from './';
import redirectToPasswordRequest from './redirect_to_password_request';
import sendMetrics from './send_metrics';

export default function requestEmailConfirmationCode(email) {
    return (dispatch, getState) => {
        if (!email || !email.trim()) {
            dispatch(setErrors(['email.empty']));
            dispatch(domikIsLoading(false));
            return;
        }

        const {
            additionalDataRequest: {track_id},
            one_domik: {processedAccount, defaultAccount},
            common: {profile_url, csrf: csrf_token}
        } = getState();
        const account = processedAccount ? processedAccount : defaultAccount;
        const params = {
            email,
            track_id,
            csrf_token,
            validator_ui_url: profile_url,
            retpath: profile_url,
            code_only: 'yes',
            uid: account ? account.uid : ''
        };

        dispatch(clearErrors());

        api.request('email/send_confirmation_email', params)
            .then(() => {
                dispatch(sendMetrics('request_email_confirmation_code', 'Показ привязки емейла', 'Отправка кода'));
                dispatch(sentEmailConfirmationCodeSuccess());
                dispatch(domikIsLoading(false));
            })
            .catch((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'email.already_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
