import api from '../../../api';
import {domikIsLoading, redirectToRetpath} from '../../actions';
import {setErrors, clearErrors, sentPhoneConfirmationCodeSuccess} from './';
import redirectToPasswordRequest from './redirect_to_password_request';
import sendMetrics from './send_metrics';

export default function requestPhoneConfirmationCode(number) {
    return (dispatch, getState) => {
        if (!number || !number.trim()) {
            dispatch(setErrors(['number.empty']));
            dispatch(domikIsLoading(false));
            return;
        }

        const {
            additionalDataRequest: {track_id, action},
            settings: {lang},
            common: {csrf: csrf_token}
        } = getState();
        const params = {
            number,
            track_id,
            csrf_token,
            display_language: lang
        };

        dispatch(clearErrors());

        api.request('phone/confirm_and_bind_secure/submit', params)
            .then((response) => {
                dispatch(
                    sendMetrics(
                        'request_phone_confirmation_code',
                        action === 'secure' ? 'Показ превращения телефона в защищенный' : 'Показ привязки телефона',
                        'Отправка кода'
                    )
                );
                dispatch(sentPhoneConfirmationCodeSuccess(response));
                dispatch(domikIsLoading(false));
            })
            .catch((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'phone.confirmed' || apiError === 'phone_secure.bound_and_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
