import {METRICS_PREFIX} from './';
import metrics from '../../../metrics';

export default function sendMetrics(type, head, act) {
    return (dispatch, getState) => {
        const {
            additionalDataRequest: {action}
        } = getState();

        let headTitle = head || '';

        if (type === 'skip_phone' || type === 'show_phone') {
            headTitle =
                (action === 'add' && 'Показ привязки телефона') ||
                (action === 'secure' && 'Показ превращения телефона в защищенный') ||
                (action === 'admit' && 'Показ актуализации телефона') ||
                'Показ привязки телефона';
        }

        if (type === 'skip_email' || type === 'show_email') {
            headTitle =
                (action === 'add' && 'Показ привязки емейла') ||
                (action === 'restore' && 'Показ превращения емейла в защищенный') ||
                'Показ привязки емейла';
        }

        if (type === 'skip_social' || type === 'show_social') {
            headTitle =
                (action === 'add' && 'Показ привязки социальщика') ||
                (action === 'allow_auth' && 'Показ включения авторизации социальщика') ||
                'Показ привязки социальщика';
        }

        metrics.goal(`${METRICS_PREFIX}_${type}`);
        metrics.send([headTitle, act]);
    };
}
