import api from '../../../api';
import {setErrors, clearErrors} from './';
import skipAdditionalData from './skip_additional_data';
import redirectToPasswordRequest from './redirect_to_password_request';
import {domikIsLoading} from '../../actions';

export default function setSocialProfileAuth(profileId = null) {
    return (dispatch, getState) => {
        const {
            additionalDataRequest: {social, track_id},
            common: {csrf: csrf_token}
        } = getState();
        const params = {
            track_id,
            csrf_token,
            profile_id: profileId || social.profile_id,
            set_auth: 1
        };

        dispatch(clearErrors());

        api.request('change_social/profile', params)
            .then(() => {
                dispatch(skipAdditionalData('no'));
            })
            .catch((error) => {
                if (error.errors.indexOf('password.required') !== -1) {
                    dispatch(redirectToPasswordRequest());
                    return;
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
