import api from '../../../api';
import {setErrors, clearErrors} from './';
import skipAdditionalData from './skip_additional_data';
import redirectToPasswordRequest from './redirect_to_password_request';
import sendMetrics from '../actions/send_metrics';
import {domikIsLoading} from '../../actions';

export default function setupConfirmedEmail(email) {
    return (dispatch, getState) => {
        const {
            one_domik: {processedAccount, defaultAccount},
            common: {csrf: csrf_token}
        } = getState();
        const account = processedAccount ? processedAccount : defaultAccount;
        const params = {
            email,
            csrf_token,
            is_safe: 'yes',
            uid: account ? account.uid : ''
        };

        dispatch(clearErrors());

        api.request('email/setup_confirmed', params)
            .then(() => {
                dispatch(sendMetrics('setup_confirmed_email', 'Показ превращения емейла в защищенный', 'Превратить'));
                dispatch(skipAdditionalData('no'));
            })
            .catch((error) => {
                if (error.errors.indexOf('password.required') !== -1) {
                    dispatch(redirectToPasswordRequest());
                    return;
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
