import api from '../../../api';
import {domikIsLoading, redirectToRetpath} from '../../actions';
import {clearErrors} from './';

export default function skipAdditionalData(userDeclined = 'yes') {
    return (dispatch, getState) => {
        const {
            additionalDataRequest: {track_id},
            common: {csrf: csrf_token}
        } = getState();
        const params = {
            track_id,
            csrf_token,
            user_declined: userDeclined
        };

        dispatch(clearErrors());

        api.request('auth/additional_data/freeze', params)
            .then(() => {
                dispatch(domikIsLoading(false));
                dispatch(redirectToRetpath());
            })
            .catch(() => {
                dispatch(domikIsLoading(false));
                dispatch(redirectToRetpath());
            });
    };
}
