import api from '../../../api';
import {domikIsLoading, redirectToRetpath} from '../../actions';
import {setErrors, clearErrors} from './';
import skipAdditionalData from './skip_additional_data';
import redirectToPasswordRequest from './redirect_to_password_request';
import sendMetrics from '../actions/send_metrics';

export default function submitEmailConfirmationCode(key) {
    return (dispatch, getState) => {
        if (!key || !key.trim()) {
            dispatch(setErrors(['key.empty']));
            dispatch(domikIsLoading(false));
            return;
        }

        const {
            additionalDataRequest: {track_id},
            one_domik: {processedAccount, defaultAccount},
            common: {csrf: csrf_token}
        } = getState();
        const account = processedAccount ? processedAccount : defaultAccount;
        const params = {
            key,
            csrf_token,
            track_id,
            uid: account ? account.uid : ''
        };

        dispatch(clearErrors());

        api.request('email/confirm/by_code', params)
            .then(() => {
                dispatch(sendMetrics('submit_email_confirmation_code', 'Показ привязки емейла', 'Успешная привязка'));
                dispatch(skipAdditionalData('no'));
            })
            .catch((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'email.already_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
