import api from '../../../api';
import {domikIsLoading, redirectToRetpath} from '../../actions';
import {setErrors, clearErrors} from './';
import skipAdditionalData from './skip_additional_data';
import redirectToPasswordRequest from './redirect_to_password_request';
import sendMetrics from './send_metrics';

export default function submitPhoneConfirmationCode(code) {
    return (dispatch, getState) => {
        if (!code || !code.trim()) {
            dispatch(setErrors(['code.empty']));
            dispatch(domikIsLoading(false));
            return;
        }

        const {
            additionalDataRequest: {track_id},
            common: {csrf: csrf_token}
        } = getState();
        const params = {
            code,
            track_id,
            csrf_token
        };

        dispatch(clearErrors());

        api.request('phone/confirm_and_bind_secure/commit', params)
            .then(() => {
                dispatch(sendMetrics('submit_phone_confirmation_code', 'Показ привязки телефона', 'Успешная привязка'));
                dispatch(skipAdditionalData('no'));
            })
            .catch((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'phone_secure.bound_and_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
