import PropTypes from 'prop-types';
import React from 'react';
import {connect} from 'react-redux';
import classnames from 'classnames';
import {Input} from '@components/Input';
import {Captcha} from '@components/Captcha';
import {handleCaptchaAnswerChange} from './captcha_field.js';

class CaptchaField extends React.Component {
    static mapStateToProps(state) {
        const {
            captcha,
            settings: {lang, ua},
            additionalDataRequest: {captchaAnswer}
        } = state;

        return {
            captcha,
            lang,
            ua,
            captchaAnswer
        };
    }

    constructor(props) {
        super(props);

        this.handleCaptchaAnswerChange = handleCaptchaAnswerChange.bind(this);
    }

    render() {
        const {captcha, lang, ua, dispatch, captchaAnswer} = this.props;
        const isMobileCaptcha = Boolean(ua.isMobile || ua.isTablet);
        const fieldName = 'captcha_answer';

        return (
            <div className='captcha-field'>
                <div className='captcha-field__block'>
                    <Captcha
                        isMobile={isMobileCaptcha}
                        lang={lang}
                        introSound={captcha.introSound}
                        captchaSound={captcha.captchaSound}
                        imageUrl={captcha.imageUrl}
                        loading={captcha.loading}
                        loadingAudio={captcha.loadingAudio}
                        playing={captcha.playing}
                        type={captcha.type}
                        dispatch={dispatch}
                        visible={true}
                    />
                </div>

                <div
                    className={classnames('form__field', {
                        form__field_filled: captchaAnswer
                    })}
                >
                    <Input
                        size='l'
                        id={fieldName}
                        name={fieldName}
                        value={captchaAnswer}
                        onChange={this.handleCaptchaAnswerChange}
                    />
                    <label htmlFor={fieldName} className='form__field-label'>
                        Введите код
                    </label>
                </div>
            </div>
        );
    }
}

CaptchaField.propTypes = {
    captcha: PropTypes.object.isRequired,
    lang: PropTypes.string.isRequired,
    ua: PropTypes.object.isRequired,
    captchaAnswer: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired
};

export default connect(CaptchaField.mapStateToProps)(CaptchaField);
