import PropTypes from 'prop-types';
import React from 'react';

import {Button} from '@components/Button';

import CaptchaField from '../../components/captcha_field.jsx';
import {additionalDataRequestErrors as errorMessages} from '../../errors';

export default function ConfirmRestoreEmail(props) {
    const {confirmRestoreEmail, goToEmailsPage, goBack, email, isCaptchaRequired, errors} = props;

    return (
        <form>
            <h1 className='request-email_title'>{i18n('AdditionalDataRequest.email.restore.title')}</h1>
            <p
                className='request-email_description'
                dangerouslySetInnerHTML={{
                    __html: i18n('AdditionalDataRequest.email.restore.description1', '<b>', email, '</b>')
                }}
            />
            <p className='request-email_description'>{i18n('AdditionalDataRequest.email.restore.description2')}</p>

            {isCaptchaRequired && <CaptchaField />}

            {errors.length !== 0 && (
                <p className='request-email_error'>
                    {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                </p>
            )}

            <div className='request-email_approve-button'>
                <Button view='action' size='l' width='max' type='submit' onClick={confirmRestoreEmail}>
                    {i18n('AdditionalDataRequest.email.restore.submit')}
                </Button>
            </div>

            <div className='request-email_back-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={goBack}>
                    {i18n('_AUTH_.email.restore.skip')}
                </Button>
            </div>

            <div className='request-email_skip-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={goToEmailsPage}>
                    {i18n('_AUTH_.email.restore.change-email')}
                </Button>
            </div>
        </form>
    );
}

ConfirmRestoreEmail.propTypes = {
    confirmRestoreEmail: PropTypes.func.isRequired,
    goToEmailsPage: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    email: PropTypes.string.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    errors: PropTypes.array.isRequired
};
