import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';

import {Button} from '@components/Button';
import {Input} from '@components/Input';

import CaptchaField from '../../components/captcha_field.jsx';
import {additionalDataRequestErrors as errorMessages} from '../../errors';

export default function EnterConfirmationCode(props) {
    const {
        handleConfirmationCodeChange,
        approveEmail,
        sentConfirmationCode,
        goEnterEmail,
        goBack,
        confirmationCode,
        email,
        isCaptchaRequired,
        errors
    } = props;
    const fieldName = 'confirmation_code';

    return (
        <form className='enter-confirmation-code_form'>
            <h1 className='request-email_title'>{i18n('AdditionalDataRequest.email.enter-confirmation-code.title')}</h1>
            <p
                className='request-email_description'
                dangerouslySetInnerHTML={{
                    __html: i18n(
                        'AdditionalDataRequest.email.enter-confirmation-code.description',
                        '<b>',
                        email,
                        '</b>'
                    )
                }}
            />
            <p className='change-email-link'>
                <span onClick={goEnterEmail} role='button'>
                    {i18n('AdditionalDataRequest.email.change-link')}
                </span>
            </p>

            <div
                className={classnames('request-email_form-field form__field', {
                    form__field_filled: confirmationCode
                })}
            >
                <Input
                    id={fieldName}
                    name={fieldName}
                    autoFocus={true}
                    value={confirmationCode}
                    onChange={handleConfirmationCodeChange}
                    size='l'
                />
                <label htmlFor={fieldName} className='form__field-label'>
                    {i18n('_AUTH_.email.enter-confirmation-code.label')}
                </label>
            </div>

            {isCaptchaRequired && <CaptchaField />}

            {errors.length !== 0 && (
                <p className='request-email_error'>
                    {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                </p>
            )}

            <div className='request-email_approve-button'>
                <Button view='action' size='l' width='max' type='submit' onClick={approveEmail}>
                    {i18n('_AUTH_.email.enter-confirmation-code.submit')}
                </Button>
            </div>

            <div className='request-email_send-again-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={sentConfirmationCode}>
                    {i18n('AdditionalDataRequest.email.enter-confirmation-code.send-again')}
                </Button>
            </div>

            <div className='request-email_skip-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={goBack}>
                    {i18n('_AUTH_.email.enter-confirmation-code.skip')}
                </Button>
            </div>
        </form>
    );
}

EnterConfirmationCode.propTypes = {
    handleConfirmationCodeChange: PropTypes.func.isRequired,
    approveEmail: PropTypes.func.isRequired,
    sentConfirmationCode: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    goEnterEmail: PropTypes.func.isRequired,
    confirmationCode: PropTypes.string.isRequired,
    email: PropTypes.string.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    errors: PropTypes.array.isRequired
};
