import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';

import {Button} from '@components/Button';
import {Input} from '@components/Input';

import CaptchaField from '../../components/captcha_field.jsx';
import {additionalDataRequestErrors as errorMessages} from '../../errors';

export default function EnterEmail(props) {
    const {handleEmailChange, sentConfirmationCode, goBack, email, isCaptchaRequired, errors} = props;
    const fieldName = 'additional_email';

    return (
        <form className='enter-email_form'>
            <h1 className='request-email_title'>{i18n('AdditionalDataRequest.email.enter-email.title')}</h1>
            <p className='request-email_description'>{i18n('AdditionalDataRequest.email.enter-email.description')}</p>

            <div
                className={classnames('request-email_form-field form__field', {
                    form__field_filled: email
                })}
            >
                <Input
                    id={fieldName}
                    name={fieldName}
                    autoFocus={true}
                    value={email}
                    onChange={handleEmailChange}
                    size='l'
                />
                <label htmlFor={fieldName} className='form__field-label'>
                    {i18n('AdditionalDataRequest.email.enter-email.label')}
                </label>
            </div>

            {isCaptchaRequired && <CaptchaField />}

            {errors.length !== 0 && (
                <p className='request-email_error'>
                    {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                </p>
            )}

            <div className='request-email_approve-button'>
                <Button view='action' size='l' width='max' type='submit' onClick={sentConfirmationCode}>
                    {i18n('_AUTH_.email.enter-email.submit')}
                </Button>
            </div>

            <div className='request-email_back-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={goBack}>
                    {i18n('_AUTH_.email.enter-email.skip')}
                </Button>
            </div>
        </form>
    );
}

EnterEmail.propTypes = {
    handleEmailChange: PropTypes.func.isRequired,
    sentConfirmationCode: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    email: PropTypes.string.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    errors: PropTypes.array.isRequired
};
