import sendApiRequest from '../actions/send_api_request';
import requestEmailConfirmationCode from '../actions/request_email_confirmation_code';
import submitEmailConfirmationCode from '../actions/submit_email_confirmation_code';
import redirectToEmailsPage from '../actions/redirect_to_emails_page';
import skipAdditionalData from '../actions/skip_additional_data';
import setupConfirmedEmail from '../actions/setup_confirmed_email';
import sendMetrics from '../actions/send_metrics';
import {changeEmail, changeConfirmationCode, changeConfirmationCodeSentStatus, clearErrors} from '../actions';

export function goBack() {
    const {dispatch} = this.props;

    dispatch(sendMetrics('skip_email', null, 'Отложить'));
    dispatch(sendApiRequest(skipAdditionalData));
}

export function handleEmailChange(event) {
    const {target = {}} = event;
    const {value} = target;

    this.props.dispatch(changeEmail(value));
}

export function handleConfirmationCodeChange(event) {
    const {target = {}} = event;
    const {value} = target;

    this.props.dispatch(changeConfirmationCode(value));
}

export function approveEmail(event) {
    event.preventDefault();

    const {dispatch, confirmationCode} = this.props;

    dispatch(sendApiRequest(submitEmailConfirmationCode, confirmationCode));
}

export function sentConfirmationCode(event) {
    event.preventDefault();

    const {dispatch, email} = this.props;

    dispatch(sendApiRequest(requestEmailConfirmationCode, email));
}

export function confirmRestoreEmail(event) {
    event.preventDefault();

    const {dispatch, email} = this.props;

    dispatch(sendApiRequest(setupConfirmedEmail, email));
}

export function goToEmailsPage() {
    this.props.dispatch(redirectToEmailsPage());
}

export function goEnterEmail() {
    const {dispatch} = this.props;

    dispatch(changeConfirmationCode(''));
    dispatch(changeConfirmationCodeSentStatus(false));
    dispatch(clearErrors());
}
