import PropTypes from 'prop-types';
import React from 'react';
import {connect} from 'react-redux';

import Pane from '../../pane.jsx';
import EnterEmail from './components/enter_email.jsx';
import EnterConfirmationCode from './components/enter_confirmation_code.jsx';
import ConfirmRestoreEmail from './components/confirm_restore_email.jsx';

import {
    goBack,
    handleEmailChange,
    handleConfirmationCodeChange,
    approveEmail,
    sentConfirmationCode,
    confirmRestoreEmail,
    goToEmailsPage,
    goEnterEmail
} from './request_email.js';

import sendMetrics from '../actions/send_metrics';

class RequestEmail extends React.Component {
    static mapStateToProps(state) {
        const {
            email,
            confirmationCode,
            isConfirmationCodeSent,
            isCaptchaRequired,
            action,
            denyResendUntil,
            errors
        } = state.additionalDataRequest;

        return {
            email,
            confirmationCode,
            isConfirmationCodeSent,
            isCaptchaRequired,
            action,
            denyResendUntil,
            errors
        };
    }

    constructor(props) {
        super(props);

        this.goBack = goBack.bind(this);
        this.handleEmailChange = handleEmailChange.bind(this);
        this.handleConfirmationCodeChange = handleConfirmationCodeChange.bind(this);
        this.approveEmail = approveEmail.bind(this);
        this.sentConfirmationCode = sentConfirmationCode.bind(this);
        this.confirmRestoreEmail = confirmRestoreEmail.bind(this);
        this.goToEmailsPage = goToEmailsPage.bind(this);
        this.goEnterEmail = goEnterEmail.bind(this);
    }

    componentDidMount() {
        this.props.dispatch(sendMetrics('show_email', null, 'Показ'));
    }

    render() {
        const {email, confirmationCode, isConfirmationCodeSent, isCaptchaRequired, action, errors} = this.props;
        const isShowEnterEmailField = (action === 'add' || action === 'confirm') && !isConfirmationCodeSent;

        return (
            <Pane>
                <div className='request-email'>
                    <div className='request-email_promo' />

                    <div className='request-email_form'>
                        {isShowEnterEmailField && (
                            <EnterEmail
                                handleEmailChange={this.handleEmailChange}
                                sentConfirmationCode={this.sentConfirmationCode}
                                goBack={this.goBack}
                                action={action}
                                isCaptchaRequired={isCaptchaRequired}
                                email={email}
                                errors={errors}
                            />
                        )}

                        {isConfirmationCodeSent && (
                            <EnterConfirmationCode
                                handleConfirmationCodeChange={this.handleConfirmationCodeChange}
                                approveEmail={this.approveEmail}
                                sentConfirmationCode={this.sentConfirmationCode}
                                goEnterEmail={this.goEnterEmail}
                                goBack={this.goBack}
                                confirmationCode={confirmationCode}
                                email={email}
                                isCaptchaRequired={isCaptchaRequired}
                                errors={errors}
                            />
                        )}

                        {action === 'restore' && (
                            <ConfirmRestoreEmail
                                confirmRestoreEmail={this.confirmRestoreEmail}
                                goToEmailsPage={this.goToEmailsPage}
                                goBack={this.goBack}
                                email={email}
                                isCaptchaRequired={isCaptchaRequired}
                                errors={errors}
                            />
                        )}
                    </div>
                </div>
            </Pane>
        );
    }
}

RequestEmail.propTypes = {
    confirmationCode: PropTypes.string.isRequired,
    isConfirmationCodeSent: PropTypes.bool.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    action: PropTypes.string.isRequired,
    errors: PropTypes.array.isRequired,
    email: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    paneCnames: PropTypes.object
};

export default connect(RequestEmail.mapStateToProps)(RequestEmail);
