import PropTypes from 'prop-types';
import React from 'react';
import {Button} from '@components/Button';
import CaptchaField from '../../components/captcha_field.jsx';
import {additionalDataRequestErrors as errorMessages} from '../../errors';

export default function ConfirmSecurePhone(props) {
    const {sentConfirmationCode, goToPhonesPage, goBack, phoneNumber, isCaptchaRequired, errors} = props;

    return (
        <form>
            <h1 className='request-phone_title'>{i18n('AdditionalDataRequest.phone.secure.title')}</h1>
            <p
                className='request-phone_description'
                dangerouslySetInnerHTML={{
                    __html: i18n('AdditionalDataRequest.phone.secure.description1', '<b>', phoneNumber, '</b>')
                }}
            />
            <p className='request-phone_description'>{i18n('AdditionalDataRequest.phone.secure.description2')}</p>

            {isCaptchaRequired && <CaptchaField />}

            {errors.length !== 0 && (
                <p className='request-phone_error'>
                    {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                </p>
            )}

            <div className='request-phone_approve-button'>
                <Button view='action' size='l' width='max' type='submit' onClick={sentConfirmationCode}>
                    {i18n('_AUTH_.phone.secure.submit')}
                </Button>
            </div>

            <div className='request-phone_back-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={goBack}>
                    {i18n('_AUTH_.phone.secure.skip')}
                </Button>
            </div>

            <div className='request-phone_skip-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={goToPhonesPage}>
                    {i18n('_AUTH_.phone.secure.change-phone')}
                </Button>
            </div>
        </form>
    );
}

ConfirmSecurePhone.propTypes = {
    sentConfirmationCode: PropTypes.func.isRequired,
    goToPhonesPage: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    phoneNumber: PropTypes.string.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    errors: PropTypes.array.isRequired
};
