import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';

import {Button} from '@components/Button';
import {Input} from '@components/Input';

import CaptchaField from '../../components/captcha_field.jsx';
import {additionalDataRequestErrors as errorMessages} from '../../errors';

export default function EnterPhone(props) {
    const {handlePhoneChange, sentConfirmationCode, goBack, phoneNumber, isCaptchaRequired, errors} = props;
    const fieldName = 'phoneNumber';

    return (
        <form>
            <h1 className='request-phone_title'>{i18n('AdditionalDataRequest.phone.enter-phone.title')}</h1>
            <p className='request-phone_description'>{i18n('AdditionalDataRequest.phone.enter-phone.description')}</p>

            <div
                className={classnames('request-phone_form-field form__field', {
                    form__field_filled: phoneNumber
                })}
            >
                <Input
                    size='l'
                    id={fieldName}
                    name={fieldName}
                    autoFocus={true}
                    value={phoneNumber}
                    onChange={handlePhoneChange}
                />
                <label htmlFor={fieldName} className='form__field-label'>
                    {i18n('AdditionalDataRequest.phone.enter-phone.label')}
                </label>
            </div>

            {isCaptchaRequired && <CaptchaField />}

            {errors.length !== 0 && (
                <p className='request-phone_error'>
                    {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                </p>
            )}

            <div className='request-phone_approve-button'>
                <Button view='action' size='l' width='max' type='submit' onClick={sentConfirmationCode}>
                    {i18n('_AUTH_.phone.enter-phone.submit')}
                </Button>
            </div>

            <div className='request-phone_back-button'>
                <Button view='pseudo' size='l' width='max' type='button' onClick={goBack}>
                    {i18n('_AUTH_.phone.enter-phone.skip')}
                </Button>
            </div>
        </form>
    );
}

EnterPhone.propTypes = {
    handlePhoneChange: PropTypes.func.isRequired,
    sentConfirmationCode: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired,
    phoneNumber: PropTypes.string.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    action: PropTypes.string.isRequired,
    errors: PropTypes.array.isRequired
};
