import PropTypes from 'prop-types';
import React from 'react';
import {showWithLeadZero, getTimerSeconds, getTimerMinutes} from './timer.js';

export default function Timer({startTime, endTime}) {
    const timerMinutes = getTimerMinutes(startTime, endTime);
    const timerSeconds = getTimerSeconds(startTime, endTime);

    return (
        <span className='timer'>
            {showWithLeadZero(timerMinutes)}:{showWithLeadZero(timerSeconds)}
        </span>
    );
}

Timer.propTypes = {
    startTime: PropTypes.number.isRequired,
    endTime: PropTypes.number.isRequired
};
