import sendApiRequest from '../actions/send_api_request';
import requestPhoneConfirmationCode from '../actions/request_phone_confirmation_code';
import submitPhoneConfirmationCode from '../actions/submit_phone_confirmation_code';
import approveActualPhone from '../actions/approve_actual_phone';
import redirectToPhonesPage from '../actions/redirect_to_phones_page';
import skipAdditionalData from '../actions/skip_additional_data';
import sendMetrics from '../actions/send_metrics';
import {changePhoneNumber, changeConfirmationCode, changeConfirmationCodeSentStatus, clearErrors} from '../actions';

export function goBack() {
    const {dispatch} = this.props;

    dispatch(sendMetrics('skip_phone', null, 'Отложить'));
    dispatch(sendApiRequest(skipAdditionalData));
}

export function handlePhoneChange(event) {
    const {target = {}} = event;
    const {value} = target;

    this.props.dispatch(changePhoneNumber(value));
}

export function handleConfirmationCodeChange(event) {
    const {target = {}} = event;
    const {value} = target;

    this.props.dispatch(changeConfirmationCode(value));
}

export function approvePhone(event) {
    event.preventDefault();

    const {dispatch, confirmationCode} = this.props;

    dispatch(sendApiRequest(submitPhoneConfirmationCode, confirmationCode));
}

export function sentConfirmationCode(event) {
    event.preventDefault();

    const {dispatch, phoneNumber} = this.props;

    dispatch(sendApiRequest(requestPhoneConfirmationCode, phoneNumber));
}

export function confirmActualPhone(event) {
    event.preventDefault();

    const {dispatch, phoneId} = this.props;

    dispatch(sendApiRequest(approveActualPhone, phoneId));
}

export function goToPhonesPage() {
    this.props.dispatch(redirectToPhonesPage());
}

export function goEnterPhone() {
    const {dispatch} = this.props;

    dispatch(changeConfirmationCode(''));
    dispatch(changeConfirmationCodeSentStatus(false));
    dispatch(clearErrors());
}
