import PropTypes from 'prop-types';
import React from 'react';
import {connect} from 'react-redux';

import EnterPhone from './components/enter_phone.jsx';
import EnterConfirmationCode from './components/enter_confirmation_code.jsx';
import ConfirmActualPhone from './components/confirm_actual_phone.jsx';
import ConfirmSecurePhone from './components/confirm_secure_phone.jsx';
import Pane from '../../pane.jsx';

import {
    goBack,
    handlePhoneChange,
    handleConfirmationCodeChange,
    approvePhone,
    sentConfirmationCode,
    confirmActualPhone,
    goToPhonesPage,
    goEnterPhone
} from './request_phone.js';

import sendMetrics from '../actions/send_metrics';

class RequestPhone extends React.Component {
    static mapStateToProps(state) {
        const {
            phone,
            confirmationCode,
            isConfirmationCodeSent,
            isCaptchaRequired,
            action,
            denyResendUntil,
            errors
        } = state.additionalDataRequest;

        return {
            confirmationCode,
            isConfirmationCodeSent,
            isCaptchaRequired,
            action,
            denyResendUntil,
            errors,
            phoneNumber: phone.number,
            phoneId: phone.id
        };
    }

    constructor(props) {
        super(props);

        this.goBack = goBack.bind(this);
        this.handlePhoneChange = handlePhoneChange.bind(this);
        this.handleConfirmationCodeChange = handleConfirmationCodeChange.bind(this);
        this.approvePhone = approvePhone.bind(this);
        this.sentConfirmationCode = sentConfirmationCode.bind(this);
        this.confirmActualPhone = confirmActualPhone.bind(this);
        this.goToPhonesPage = goToPhonesPage.bind(this);
        this.goEnterPhone = goEnterPhone.bind(this);
    }

    componentDidMount() {
        this.props.dispatch(sendMetrics('show_phone', null, 'Показ'));
    }

    render() {
        const {
            phoneNumber,
            confirmationCode,
            isConfirmationCodeSent,
            isCaptchaRequired,
            action,
            denyResendUntil,
            errors
        } = this.props;
        const isShowEnterPhoneField = (action === 'add' || action === 'confirm') && !isConfirmationCodeSent;

        return (
            <Pane>
                <div className='request-phone'>
                    <div className='request-phone_promo' />

                    <div className='request-phone_form'>
                        {isShowEnterPhoneField && (
                            <EnterPhone
                                handlePhoneChange={this.handlePhoneChange}
                                sentConfirmationCode={this.sentConfirmationCode}
                                goBack={this.goBack}
                                action={action}
                                phoneNumber={phoneNumber}
                                isCaptchaRequired={isCaptchaRequired}
                                errors={errors}
                            />
                        )}

                        {isConfirmationCodeSent && (
                            <EnterConfirmationCode
                                handleConfirmationCodeChange={this.handleConfirmationCodeChange}
                                approvePhone={this.approvePhone}
                                sentConfirmationCode={this.sentConfirmationCode}
                                goBack={this.goBack}
                                goEnterPhone={this.goEnterPhone}
                                confirmationCode={confirmationCode}
                                phoneNumber={phoneNumber}
                                action={action}
                                isCaptchaRequired={isCaptchaRequired}
                                denyResendUntil={denyResendUntil}
                                errors={errors}
                            />
                        )}

                        {action === 'admit' && !isConfirmationCodeSent && (
                            <ConfirmActualPhone
                                confirmActualPhone={this.confirmActualPhone}
                                goToPhonesPage={this.goToPhonesPage}
                                goBack={this.goBack}
                                phoneNumber={phoneNumber}
                                isCaptchaRequired={isCaptchaRequired}
                                errors={errors}
                            />
                        )}

                        {action === 'secure' && !isConfirmationCodeSent && (
                            <ConfirmSecurePhone
                                sentConfirmationCode={this.sentConfirmationCode}
                                goToPhonesPage={this.goToPhonesPage}
                                goBack={this.goBack}
                                phoneNumber={phoneNumber}
                                isCaptchaRequired={isCaptchaRequired}
                                errors={errors}
                            />
                        )}
                    </div>
                </div>
            </Pane>
        );
    }
}

RequestPhone.propTypes = {
    confirmationCode: PropTypes.string.isRequired,
    isConfirmationCodeSent: PropTypes.bool.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    action: PropTypes.string.isRequired,
    errors: PropTypes.array.isRequired,
    phoneNumber: PropTypes.string.isRequired,
    phoneId: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    denyResendUntil: PropTypes.number,
    paneCnames: PropTypes.object
};

export default connect(RequestPhone.mapStateToProps)(RequestPhone);
