import PropTypes from 'prop-types';
import React from 'react';
import {Button} from '@components/Button';
import CaptchaField from '../../components/captcha_field.jsx';
import {additionalDataRequestErrors as errorMessages} from '../../errors';

export default function AddSocialProfile(props) {
    const {providers, isCaptchaRequired, errors, addSocialProfile, goBack} = props;

    return (
        <form className='add-social-profile__form'>
            <h1 className='request-social_title'>{i18n('AdditionalDataRequest.social.add.title')}</h1>

            {isCaptchaRequired && <CaptchaField />}

            {errors.length !== 0 && (
                <p className='request-social_error'>
                    {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                </p>
            )}

            <div className='request-social_providers'>
                {providers.map((provider, providerIndex) => (
                    <div key={provider.code} className={`provider provider-${provider.code}`}>
                        <span className='provider-icon' />
                        <Button
                            onClick={() => addSocialProfile(provider.code)}
                            view='pseudo'
                            tabIndex={String(providerIndex + 1)}
                            size='l'
                            width='max'
                            type='button'
                        >
                            {provider.display_name}
                        </Button>
                    </div>
                ))}
            </div>

            <div className='request-social_back-button'>
                <Button
                    view='pseudo'
                    size='l'
                    width='max'
                    type='button'
                    tabIndex={String(providers.length + 1)}
                    onClick={goBack}
                >
                    {i18n('AdditionalDataRequest.social.add.skip')}
                </Button>
            </div>
        </form>
    );
}

AddSocialProfile.propTypes = {
    providers: PropTypes.array.isRequired,
    isCaptchaRequired: PropTypes.bool.isRequired,
    errors: PropTypes.array.isRequired,
    addSocialProfile: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired
};
