import PropTypes from 'prop-types';
import React from 'react';
import {Button} from '@components/Button';
import CaptchaField from '../../components/captcha_field.jsx';
import {additionalDataRequestErrors as errorMessages} from '../../errors';

export default class AllowSocialAuth extends React.Component {
    constructor(props) {
        super(props);

        this.handleEnterKeyPress = this.handleEnterKeyPress.bind(this);
    }

    componentDidMount() {
        (window.addEventListener || window.attachEvent)('keypress', this.handleEnterKeyPress);
    }

    componentWillUnmount() {
        (window.removeEventListener || window.detachEvent)('keypress', this.handleEnterKeyPress);
    }

    handleEnterKeyPress(event) {
        if (event.keyCode === 13) {
            this.props.allowSocialAuth();
        }
    }

    render() {
        const {
            isCaptchaRequired,
            errors,
            socialUserName,
            socialLink,
            providerCode,
            allowSocialAuth,
            goBack
        } = this.props;

        return (
            <form onSubmit={allowSocialAuth} className='allow-social-auth__form'>
                <h1 className='request-social_title'>{i18n('AdditionalDataRequest.social.allow.title')}</h1>
                <p className='request-social_description'>{i18n('AdditionalDataRequest.social.allow.description')}</p>
                <p className='social-username'>
                    <span className={`social-icon social-icon__${providerCode}`} />
                    <a
                        href={socialLink}
                        target='_blank'
                        className='social-name passport-Domik-Link'
                        rel='noopener noreferrer'
                    >
                        {socialUserName}
                    </a>
                </p>

                {isCaptchaRequired && <CaptchaField />}

                {errors.length !== 0 && (
                    <p className='request-social_error'>
                        {errorMessages[errors[0]] ? errorMessages[errors[0]] : errorMessages.internal}
                    </p>
                )}

                <div className='request-social_approve-button'>
                    <Button view='action' size='l' width='max' type='submit'>
                        {i18n('AdditionalDataRequest.social.allow.submit')}
                    </Button>
                </div>

                <div className='request-social_back-button'>
                    <Button view='pseudo' size='l' width='max' type='button' onClick={goBack}>
                        {i18n('AdditionalDataRequest.social.allow.skip')}
                    </Button>
                </div>
            </form>
        );
    }
}

AllowSocialAuth.propTypes = {
    isCaptchaRequired: PropTypes.bool.isRequired,
    errors: PropTypes.array.isRequired,
    socialUserName: PropTypes.string.isRequired,
    socialLink: PropTypes.string.isRequired,
    providerCode: PropTypes.string.isRequired,
    allowSocialAuth: PropTypes.func.isRequired,
    goBack: PropTypes.func.isRequired
};
