import sendApiRequest from '../actions/send_api_request';
import skipAdditionalData from '../actions/skip_additional_data';
import setSocialProfileAuth from '../actions/set_social_profile_auth';
import broker from '../../authorized_broker';
import sendMetrics from '../actions/send_metrics';

export function goBack() {
    const {dispatch} = this.props;

    dispatch(sendMetrics('skip_social', null, 'Отложить'));
    dispatch(sendApiRequest(skipAdditionalData));
}

export function allowSocialAuth(event) {
    event && typeof event.preventDefault === 'function' && event.preventDefault();

    const {dispatch} = this.props;

    dispatch(sendMetrics('allow_social_auth', 'Показ включения авторизации социальщика', 'Подтвердить'));
    dispatch(sendApiRequest(setSocialProfileAuth));
}

export function addSocialProfile(provider) {
    this.props.dispatch(sendMetrics(`add_social_profile_${provider}`, 'Показ привязки социальщика', 'Выбор соц сети'));

    broker.start({
        provider,
        bind: 1,
        return_brief_profile: 1
    });
}

export function filterProvidersListByTLD(providers, tld, lang) {
    const isKUBR = ['kz', 'ua', 'by', 'ru'].indexOf(tld) !== -1;

    return providers
        .filter((provider) => {
            const code = provider.data.code;

            if (code === 'fb') {
                return true;
            }

            if (isKUBR) {
                return code === 'vk';
            }

            return code === 'gg';
        })
        .map(({data}) =>
            Object.assign({}, data, {
                display_name: data.display_name[lang] ? data.display_name[lang] : data.display_name.default
            })
        );
}

export function getSocialUserName(social) {
    if (!social) {
        return '';
    }

    if (social.firstname && social.lastname) {
        return `${social.firstname} ${social.lastname}`.trim();
    }

    return social.username || social.userid || '';
}
