import PropTypes from 'prop-types';
import React from 'react';
import {connect} from 'react-redux';

import Pane from '../../pane.jsx';
import AddSocialProfile from './components/add_social_profile.jsx';
import AllowSocialAuth from './components/allow_social_auth.jsx';
import {
    goBack,
    addSocialProfile,
    allowSocialAuth,
    filterProvidersListByTLD,
    getSocialUserName
} from './request_social.js';

import sendMetrics from '../actions/send_metrics';

class RequestSocial extends React.Component {
    static mapStateToProps(state) {
        const {
            settings: {lang, tld},
            social: {providers},
            additionalDataRequest: {isCaptchaRequired, errors, social, action}
        } = state;

        const providerList = filterProvidersListByTLD(providers, tld, lang);
        const socialUserName = getSocialUserName(social);

        return {
            isCaptchaRequired,
            errors,
            socialUserName,
            action,
            providers: providerList,
            socialLink: (social && Array.isArray(social.addresses) && social.addresses[0]) || '',
            providerCode: (social && social.provider_code) || ''
        };
    }

    constructor(props) {
        super(props);

        this.goBack = goBack.bind(this);
        this.addSocialProfile = addSocialProfile.bind(this);
        this.allowSocialAuth = allowSocialAuth.bind(this);
    }

    componentDidMount() {
        this.props.dispatch(sendMetrics('show_social', null, 'Показ'));
    }

    render() {
        const {providers, isCaptchaRequired, action, socialUserName, socialLink, providerCode, errors} = this.props;

        return (
            <Pane>
                <div className='request-social'>
                    <div className='request-social_promo' />

                    {action === 'add' && (
                        <AddSocialProfile
                            providers={providers}
                            errors={errors}
                            isCaptchaRequired={isCaptchaRequired}
                            addSocialProfile={this.addSocialProfile}
                            goBack={this.goBack}
                        />
                    )}

                    {action === 'allow_auth' && (
                        <AllowSocialAuth
                            socialUserName={socialUserName}
                            socialLink={socialLink}
                            providerCode={providerCode}
                            errors={errors}
                            isCaptchaRequired={isCaptchaRequired}
                            allowSocialAuth={this.allowSocialAuth}
                            goBack={this.goBack}
                        />
                    )}
                </div>
            </Pane>
        );
    }
}

RequestSocial.propTypes = {
    isCaptchaRequired: PropTypes.bool.isRequired,
    errors: PropTypes.array.isRequired,
    action: PropTypes.string.isRequired,
    providers: PropTypes.array.isRequired,
    dispatch: PropTypes.func.isRequired,
    socialUserName: PropTypes.string,
    providerCode: PropTypes.string,
    socialLink: PropTypes.string
};

export default connect(RequestSocial.mapStateToProps)(RequestSocial);
