import passport from '@plibs/pclientjs/js/passport';
import AuthorizedBroker from '@old-blocks/social/authorized_broker';
import setSocialProfileAuth from './additional_data_request/actions/set_social_profile_auth';
import sendApiRequest from './additional_data_request/actions/send_api_request';

let store;
const brokerWrapper = {
    init(s) {
        store = s;
        const state = store.getState();
        const social = state.social;
        const display = state.customs.display;
        const retpath = state.common.retpath || `${location.protocol}//${location.host}/profile`;
        const brokerpath = social.brokerPath;
        const tld = state.settings.tld;
        const brokerParams = {};
        const self = this;

        brokerParams.resize = 1;
        brokerParams.startUrl = brokerpath.replace('%tld%', tld);

        if (display === 'popup' || display === 'touch' || passport.isTouch) {
            brokerParams.display = 'touch';
            brokerParams.retnopopup = retpath;
        }

        if (window.addEventListener) {
            window.addEventListener('message', self.onSuccess);
        } else {
            window.attachEvent('onmessage', self.onSuccess);
        }
        window.socialResponseAuthorized = function(data) {
            self.onSuccess({
                // eslint-disable-next-line compat/compat
                origin: location.origin,
                data
            });
        };

        window.authorizedBroker = new AuthorizedBroker();
        window.authorizedBroker.init(brokerParams);
    },

    onSuccess(message) {
        if (message.origin !== location.origin) {
            return;
        }

        if (!message.data.socialAuth) {
            return;
        }

        if (!message.data['profile.profile_id']) {
            return;
        }

        store.dispatch(sendApiRequest(setSocialProfileAuth, message.data['profile.profile_id']));
    },

    start(params) {
        window.authorizedBroker.start(params);
    }
};

export default brokerWrapper;
