import passport from '@plibs/pclientjs/js/passport';
import metrics from '@blocks/metrics';
import broker from '@old-blocks/social/broker';
import {redirectToRetpath, redirectToBackpath, ONE_DOMIK_GOAL_PREFIX} from './actions';

let store;
const brokerWrapper = {
    init(s) {
        store = s;
        const state = store.getState();
        const social = state.social;
        const display = state.customs.display;
        const brokerParams = {};
        const self = this;

        let retpath = state.common.retpath || `${location.protocol}//${location.host}/profile`;

        if (state.common.origin === 'yandex') {
            retpath = state.common.backpath || `${location.protocol}//${location.host}/profile`;
        }

        brokerParams.resize = 1;
        brokerParams.startUrl = social.brokerParams.startUrl;

        if (display === 'popup' || display === 'touch' || passport.isTouch) {
            brokerParams.display = 'touch';
            brokerParams.retnopopup = retpath;
        }

        if (window.addEventListener) {
            window.addEventListener('message', self.onSuccess);
        } else {
            window.attachEvent('onmessage', self.onSuccess);
        }

        if (!window.location.origin) {
            window.location.origin = `${window.location.protocol}//${window.location.hostname}`;
        }

        window.socialResponse = function(data) {
            self.onSuccess({
                // eslint-disable-next-line compat/compat
                origin: location.origin,
                data
            });
        };

        broker.init(brokerParams);
    },

    onSuccess(message) {
        const state = store.getState();
        const common = state.common;
        const reqOrigin = common.origin;

        if (message.origin !== location.origin) {
            return;
        }

        if (!message.data.socialAuth) {
            return;
        }

        if (state.common.pane.match(/\/auth\/social/)) {
            return;
        }

        if (message.data.status === 'ok') {
            metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_social_auth_success`);
            metrics.send(['Успешная соцавторизация']);

            if (reqOrigin === 'yandex') {
                store.dispatch(redirectToBackpath());
            } else {
                store.dispatch(redirectToRetpath());
            }
        } else {
            metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_social_auth_fail`);
            metrics.send(['Безуспешная соцавторизация']);
        }
    },

    start(params) {
        broker.start(params);
    }
};

export default brokerWrapper;

export const START_SOCIAL_AUTH = 'START_SOCIAL_AUTH';

export function startSocialAuth(params) {
    return function(dispatch, getState) {
        const state = getState();
        const brokerParams = {
            track_id: state.common.track_id,
            provider: params.provider
        };

        if (params.scope) {
            brokerParams.scope = params.scope;
        }

        dispatch({
            type: START_SOCIAL_AUTH
        });

        broker.start(brokerParams);
    };
}
