import passport from '@plibs/pclientjs/js/passport';
import {getQuery, storageAvailable} from '@blocks/utils';

const PID_NAME = 'pid';

const wrapper = {
    init(store) {
        const state = store.getState();
        const {isYandex} = state.common;
        const {retpath, mode, force_auth, no_pulse} = getQuery();
        const self = this;

        if (no_pulse === '1') {
            return;
        }

        if (isYandex) {
            return;
        }

        if (!retpath || force_auth === '1' || ['add-user', 'edit'].indexOf(mode) !== -1) {
            return;
        }

        setTimeout(() => {
            self.POLLING_TIMEOUT = 5000;
            self.LEADER_TIMEOUT = 15000;
        }, 60000);

        if (storageAvailable('localStorage')) {
            window.addEventListener('storage', this.onStorage.bind(this));
            this.chooseWay(null);
        }
    },
    POLLING_TIMEOUT: 1000,
    LEADER_TIMEOUT: 3000,

    chooseWay(lastKnownPid) {
        const actualPid = localStorage.getItem(PID_NAME);

        if (lastKnownPid === actualPid) {
            return this.startAsALeader();
        } else {
            return this.startAsANormie(actualPid);
        }
    },

    startAsALeader() {
        const pid = this.generateId(10);

        localStorage.setItem(PID_NAME, pid);
        setTimeout(() => this.singleRequest(pid), this.POLLING_TIMEOUT);
    },

    startAsANormie(pid) {
        setTimeout(() => this.chooseWay(pid), this.LEADER_TIMEOUT);
    },

    finish() {
        localStorage.removeItem(PID_NAME);
        this.reload();
    },

    onStorage(event) {
        if (event.key === 'pid') {
            if (event.newValue === null) {
                this.reload();
            }
        }
    },

    reload() {
        window.location.search += '&no_pulse=1';
    },

    singleRequest(lastKnownPid) {
        const self = this;

        passport.api
            .request('/auth/pulse', {})
            .done((result) => {
                if (result.status === 'ok') {
                    self.finish();
                } else {
                    self.chooseWay(lastKnownPid);
                }
            })
            .fail(function() {
                self.chooseWay(lastKnownPid);
            });
    },

    dec2hex(dec) {
        return `0${dec.toString(16)}`.substr(-2);
    },

    generateId(len) {
        // eslint-disable-next-line compat/compat
        const arr = new Uint8Array((len || 40) / 2);
        const crypto = window.crypto || window.msCrypto;

        crypto.getRandomValues(arr);
        return [].slice
            .call(arr)
            .map(this.dec2hex)
            .join('');
    }
};

export default wrapper;
