import PropTypes from 'prop-types';
import React, {Component} from 'react';

export class CurrentAccount extends Component {
    render() {
        const {account, avatar} = this.props;

        const spanStyle = {
            backgroundImage: `url(https://${avatar.host}${avatar.pathname
                .replace('%uid%', account.avatarId)
                .replace('%size%', '200')
                .replace('%login%', account.login)})`
        };

        return (
            <h3 className='passport-Domik-Account'>
                <span className='passport-Domik-Account-Userpic passport-Userpic' style={spanStyle} />
                <span className='passport-Domik-Account-Name'>{account.displayName}</span>
            </h3>
        );
    }
}

CurrentAccount.propTypes = {
    account: PropTypes.object,
    avatar: PropTypes.object
};
