import PropTypes from 'prop-types';
import React, {Component} from 'react';
import classnames from 'classnames';
import {createSelector} from 'reselect';
import {connect} from 'react-redux';
import {doRequestInfo} from './actions.js';

import {selectErrors} from '../selectors.js';

const doNotShow = ['account.auth_passed', 'track.not_found'];

const messages = {
    'account.disabled': i18n('_AUTH_.Errors.account.disabled'),
    'account.disabled_on_deletion': i18n('_AUTH_.Errors.account.disabled'),
    'account.not_found': i18n('_AUTH_.Errors.account.not_found'),
    'captcha.invalid': i18n('_AUTH_.Errors.captcha.invalid'),
    'captcha.required': i18n('_AUTH_.Errors.captcha.required'),
    'login.empty': i18n('_AUTH_.Errors.login.empty'),
    'password.empty': i18n('_AUTH_.Errors.password.empty'),
    'password.not_matched_2fa': i18n('OneDomik.Errors.password.not_matched_2fa'),
    'password.not_matched': i18n('_AUTH_.Errors.password.not_matched'),
    'rfc_otp.invalid': i18n('_AUTH_.Errors.password.not_matched'),
    'sessionid.overflow': i18n('_AUTH_.Errors.sessionidoverflow'),
    internal: i18n('_AUTH_.Errors.internal')
};

const info = {
    'account.not_found': i18n('OneDomik.Errors.account.not_found.extended'),
    'password.not_matched_2fa': i18n('OneDomik.Errors.password.not_matched_2fa.extended'),
    'password.not_matched': i18n('OneDomik.Errors.password.not_matched.extended'),
    'sessionid.overflow': i18n('_AUTH_.Errors.sessionidoverflow.extended')
};

const select = createSelector(selectErrors, (state) => ({
    code: state.code,
    isExpanded: state.isExpanded
}));

const actions = {
    requestInfo: doRequestInfo
};

class Errors extends Component {
    constructor(props) {
        super(props);

        this.requestInfo = props.requestInfo.bind(this);
    }

    render() {
        const {code, isExpanded} = this.props;

        const errorFieldClassNames = {
            'passport-Domik-Form-Error': true,
            'passport-Domik-Form-Error_active': Boolean(code)
        };

        if (doNotShow.indexOf(code) !== -1) {
            errorFieldClassNames['passport-Domik-Form-Error_active'] = false;
        }

        // account.not_found
        // action.not_required
        // captcha.captchalocate
        // captcha.invalid
        // captcha.required
        // login.empty
        // password.empty
        // password.not_matched
        // sessionid.invalid
        // sessionid.no_uid
        // session.no_uid
        // uid.empty
        // yu.empty
        // yu.invalid
        //

        return (
            <div className={classnames(errorFieldClassNames)}>
                {messages[code] || (code && messages.internal)}

                {!isExpanded && info[code] && (
                    <a
                        className='passport-Icon
                        passport-Icon_error_help
                        passport-Domik-Form-Error-Icon'
                        onClick={this.requestInfo}
                    >
                        <svg className='passport-Icon-SVG'>
                            <use xlinkHref='#Icon_error_help' />
                        </svg>
                    </a>
                )}

                {isExpanded && info[code] && <div className='passport-Domik-Form-Error__Message'>{info[code]}</div>}
            </div>
        );
    }
}

Errors.propTypes = {
    code: PropTypes.string,
    requestInfo: PropTypes.func,
    isExpanded: PropTypes.bool
};

export default connect(select, actions)(Errors);
