import {
    PROCESS_EMB_ANSWER,
    SHOW_ACCOUNTS_SUCCESS,
    SHOW_MAGIC_ERROR,
    SWITCH_MODE_TO_ADDING_ACCOUNT,
    SWITCH_MODE_TO_EDIT,
    SWITCH_TO_MAGIC,
    SWITCH_TO_RFC_TOTP
} from '../actions';

import {CLEAR_ERRORS, INFO_REQUESTED} from './actions';

import {LOGIN_CHANGED, PASSWORD_CHANGED, CAPTCHA_CHANGED} from '../form/actions.js';

const ROUTER_LOCATION_CHANGE = '@@router/LOCATION_CHANGE';

export default function(state = {}, action) {
    switch (action.type) {
        case INFO_REQUESTED: {
            return Object.assign({}, state, {
                isExpanded: true
            });
        }
        case SHOW_MAGIC_ERROR: {
            return Object.assign({}, state, {
                code: action.errors
            });
        }
        case PROCESS_EMB_ANSWER: {
            return Object.assign({}, state, {
                code: action.data.errors
            });
        }
        case SHOW_ACCOUNTS_SUCCESS:
        case SWITCH_MODE_TO_ADDING_ACCOUNT:
        case SWITCH_MODE_TO_EDIT:
        case SWITCH_TO_MAGIC:
        case SWITCH_TO_RFC_TOTP:
        case ROUTER_LOCATION_CHANGE:
        case CLEAR_ERRORS:
        case LOGIN_CHANGED:
        case PASSWORD_CHANGED:
        case CAPTCHA_CHANGED:
            return Object.assign({}, state, {
                code: null,
                isExpanded: false
            });
        default:
            return state;
    }
}
