import PropTypes from 'prop-types';
import React, {Component} from 'react';
import classnames from 'classnames';
import {Captcha} from '@components/Captcha';

export default class CaptchaField extends Component {
    render() {
        const {
            isIE,
            captchaIsEmpty,
            errors,
            isMobileCaptcha,
            lang,
            captcha,
            refBind,
            dispatch,
            notify,
            toggleCaptchaEmptyState
        } = this.props;

        const captchaInputClassnames = {
            'passport-Input': true,
            'passport-Input_empty': isIE && captchaIsEmpty
        };

        const captchaFieldClassnames = {
            'passport-Domik-Form-Field': true,
            'passport-Domik-Form-Field-State_error':
                ['captcha.required', 'captcha.invalid'].indexOf(errors) > -1 &&
                this.captchaInput &&
                this.captchaInput.value === ''
        };

        return (
            <div>
                <div className='passport-Domik-Form-Field'>
                    <Captcha
                        isMobile={isMobileCaptcha}
                        lang={lang}
                        introSound={captcha.introSound}
                        captchaSound={captcha.captchaSound}
                        imageUrl={captcha.imageUrl}
                        loading={captcha.loading}
                        loadingAudio={captcha.loadingAudio}
                        playing={captcha.playing}
                        type={captcha.type}
                        dispatch={dispatch}
                        visible={true}
                    />
                </div>
                <div className={classnames(captchaFieldClassnames)}>
                    <label className={classnames(captchaInputClassnames)}>
                        <input
                            type='text'
                            placeholder=' '
                            name='captcha_answer'
                            autoCorrect='off'
                            autoCapitalize='off'
                            autoComplete='off'
                            onChange={notify}
                            onInput={toggleCaptchaEmptyState}
                            ref={refBind}
                            className='passport-Input-Controller'
                        />
                        <span className='passport-Input-View'>
                            <span className='passport-Input-Label'>{i18n('OneDomik.Form.Label.Captcha')}</span>
                        </span>
                    </label>
                </div>
            </div>
        );
    }
}

CaptchaField.propTypes = {
    captcha: PropTypes.object,
    captchaIsEmpty: PropTypes.bool,
    notify: PropTypes.func,
    toggleCaptchaEmptyState: PropTypes.func,
    dispatch: PropTypes.func,
    errors: PropTypes.string,
    isIE: PropTypes.bool,
    isMobileCaptcha: PropTypes.bool,
    lang: PropTypes.string,
    refBind: PropTypes.func
};
