import PropTypes from 'prop-types';
import React, {Component} from 'react';
import classnames from 'classnames';

export default class LoginField extends Component {
    render() {
        const {isIE, loginIsEmpty, errors, notify, refBind, toggleLoginEmptyState} = this.props;

        const loginFieldClassnames = {
            'passport-Domik-Form-Field': true,
            'passport-Domik-Form-Field-State_error':
                ['account.not_found', 'account.dissbled', 'login.empty'].indexOf(errors) > -1
        };

        const loginInputClassnames = {
            'passport-Input': true,
            'passport-Input_empty': isIE && loginIsEmpty
        };

        const label = this.props.isPhoneNumberExperiment
            ? i18n('OneDomik.Form.Label.LoginOrPhoneNumber')
            : i18n('OneDomik.Form.Label.Login');

        return (
            <div className={classnames(loginFieldClassnames)}>
                <label className={classnames(loginInputClassnames)}>
                    <input
                        onChange={notify}
                        onInput={toggleLoginEmptyState}
                        name='login'
                        type='text'
                        autoCorrect='off'
                        autoCapitalize='off'
                        autoComplete='username'
                        placeholder=' '
                        ref={refBind}
                        className='passport-Input-Controller'
                    />
                    <span className='passport-Input-View'>
                        <span className='passport-Input-Label'>{label}</span>
                    </span>
                </label>
            </div>
        );
    }
}

LoginField.propTypes = {
    notify: PropTypes.func.isRequired,
    toggleLoginEmptyState: PropTypes.func.isRequired,
    errors: PropTypes.string,
    isIE: PropTypes.bool.isRequired,
    isPhoneNumberExperiment: PropTypes.bool,
    loginIsEmpty: PropTypes.bool.isRequired,
    refBind: PropTypes.func.isRequired
};
