import PropTypes from 'prop-types';
import React, {Component} from 'react';
import classnames from 'classnames';

export default class OTPField extends Component {
    render() {
        const {
            isIE,
            isMobile,
            passwordType,
            passwordIsEmpty,
            togglePasswordEmptyState,
            togglePasswordType,
            errors,
            refBind,
            notify,
            login
        } = this.props;

        const passwordEyeClassnames = {
            'password-eye': true,
            'password-eye__hidden': passwordType === 'text'
        };

        const passwordInputClassnames = {
            'passport-Input': true,
            'passport-Input_empty': isIE && passwordIsEmpty
        };

        const passwordFieldClassnames = {
            'passport-Domik-Form-Field': true,
            'passport-Domik-Form-Field_with_toggle': Boolean(isMobile),
            'passport-Domik-Form-Field-State_error':
                ['password.not_matched', 'password.empty'].indexOf(errors) > -1 &&
                this.passwordInput &&
                this.passwordInput.value === ''
        };

        return (
            <div className={classnames(passwordFieldClassnames)}>
                {Boolean(isMobile) && (
                    <span className={classnames(passwordEyeClassnames)} onClick={togglePasswordType} />
                )}

                <label className={classnames(passwordInputClassnames)}>
                    <input type='hidden' name='login' autoComplete='username' value={login} readOnly={true} />
                    <input
                        name='password'
                        type={passwordType}
                        autoCorrect='off'
                        autoCapitalize='off'
                        autoComplete='off'
                        placeholder=' '
                        onChange={notify}
                        onInput={togglePasswordEmptyState}
                        className='passport-Input-Controller'
                        ref={refBind}
                    />
                    <span className='passport-Input-View'>
                        <span className='passport-Input-Label'>{i18n('OneDomik.Form.Label.OTP')}</span>
                    </span>
                </label>
            </div>
        );
    }
}

OTPField.propTypes = {
    notify: PropTypes.func.isRequired,
    togglePasswordEmptyState: PropTypes.func.isRequired,
    togglePasswordType: PropTypes.func.isRequired,
    errors: PropTypes.string,
    isIE: PropTypes.bool,
    isMobile: PropTypes.bool,
    login: PropTypes.string,
    passwordIsEmpty: PropTypes.bool,
    passwordType: PropTypes.string,
    refBind: PropTypes.func
};
